/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.NotNullInstrumenter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import se.eris.maven.MavenLogWrapper;
import se.eris.notnull.AnnotationConfiguration;
import se.eris.notnull.Configuration;
import se.eris.notnull.ExcludeConfiguration;
import se.eris.notnull.instrumentation.ClassMatcher;

abstract class AbstractNotNullInstrumenterTask
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    MavenProject project;
    @Parameter
    private Set<String> notNull;
    @Parameter
    private Set<String> nullable;
    @Parameter
    private Set<String> excludes;
    @Parameter
    private boolean implicit;
    @Parameter(property="se.eris.notnull.instrument", defaultValue="true")
    private boolean instrument;
    private final NotNullInstrumenter instrumenter;
    private final MavenLogWrapper logger = new MavenLogWrapper(this.getLog());

    public AbstractNotNullInstrumenterTask() {
        this.instrumenter = new NotNullInstrumenter(this.logger);
    }

    void instrument(Path classesDirectory, @NotNull Iterable<String> classpathElements) throws MojoExecutionException {
        if (!this.instrument) {
            return;
        }
        Configuration configuration = this.getConfiguration();
        this.logAnnotations(configuration);
        List<URL> classpathUrls = this.getClasspathUrls(classpathElements);
        int instrumented = this.instrumenter.addNotNullAnnotations(classesDirectory, configuration, classpathUrls);
        this.logger.info("Instrumented " + instrumented + " files with NotNull assertions");
    }

    @NotNull
    private List<URL> getClasspathUrls(@NotNull Iterable<String> classpathElements) throws MojoExecutionException {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (String cp : classpathElements) {
                urls.add(new File(cp).toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Cannot convert classpath element into URL", (Exception)e);
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException(e.getMessage(), e.getCause());
        }
        return urls;
    }

    private Configuration getConfiguration() {
        return new Configuration(this.implicit, this.getAnnotationConfiguration(this.nullToEmpty(this.notNull), this.nullToEmpty(this.nullable)), this.getExcludeConfiguration(this.nullToEmpty(this.excludes)));
    }

    private AnnotationConfiguration getAnnotationConfiguration(Set<String> notNull, Set<String> nullable) {
        return new AnnotationConfiguration(notNull, nullable);
    }

    private ExcludeConfiguration getExcludeConfiguration(Set<String> excludes) {
        HashSet<ClassMatcher> excludeMatchers = new HashSet<ClassMatcher>();
        for (String exclude : excludes) {
            excludeMatchers.add(ClassMatcher.namePattern(exclude));
        }
        return new ExcludeConfiguration(excludeMatchers);
    }

    private Set<String> nullToEmpty(Set<String> set) {
        return set != null ? set : Collections.emptySet();
    }

    private void logAnnotations(@NotNull Configuration configuration) {
        if (!configuration.getNotNullAnnotations().isEmpty()) {
            this.logger.info("Using the following NotNull annotations:");
            for (String notNullAnnotation : configuration.getNotNullAnnotations()) {
                this.logger.info("  " + notNullAnnotation);
            }
        }
        if (!configuration.getNullableAnnotations().isEmpty()) {
            this.logger.info("Using the following Nullable annotations:");
            for (String nullableAnnotation : configuration.getNullableAnnotations()) {
                this.logger.info("  " + nullableAnnotation);
            }
        }
    }
}

