/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import com.intellij.compiler.instrumentation.InstrumenterClassWriter;
import com.intellij.compiler.notNullVerification.NotNullInstrumenterClassVisitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import se.eris.asm.AsmUtils;
import se.eris.maven.LogWrapper;
import se.eris.notnull.Configuration;
import se.eris.notnull.InstrumentExecutionException;
import se.eris.util.ClassFileUtils;

public class NotNullInstrumenter {
    private static final int NO_FLAGS = 0;
    @NotNull
    private final LogWrapper logger;

    public NotNullInstrumenter(@NotNull LogWrapper logWrapper) {
        this.logger = logWrapper;
    }

    public int addNotNullAnnotations(Path classesDirectory, Configuration configuration, @NotNull List<URL> urls) {
        InstrumentationClassFinder finder = new InstrumentationClassFinder(urls.toArray(new URL[urls.size()]));
        return this.instrumentDirectoryRecursive(classesDirectory, finder, configuration);
    }

    private int instrumentDirectoryRecursive(Path classesDirectory, @NotNull InstrumentationClassFinder finder, Configuration configuration) {
        int instrumentedCounter = 0;
        Set<File> classes = ClassFileUtils.getClassFiles(classesDirectory);
        for (File file : classes) {
            instrumentedCounter += this.instrumentFile(file, finder, configuration);
        }
        return instrumentedCounter;
    }

    private int instrumentFile(@NotNull File file, @NotNull InstrumentationClassFinder finder, Configuration configuration) {
        this.logger.debug("Adding NotNull assertions to " + file.getPath());
        try {
            return NotNullInstrumenter.instrumentClass(file, finder, configuration) ? 1 : 0;
        }
        catch (IOException | RuntimeException e) {
            throw new InstrumentExecutionException("NotNull instrumentation failed for " + file.getPath(), e);
        }
    }

    /*
     * Loose catch block
     */
    private static boolean instrumentClass(@NotNull File file, @NotNull InstrumentationClassFinder finder, Configuration configuration) throws IOException {
        block29: {
            Throwable throwable = null;
            try (FileInputStream inputStream = new FileInputStream(file);){
                ClassReader classReader = new ClassReader((InputStream)inputStream);
                int fileVersion = NotNullInstrumenter.getClassFileVersion(classReader);
                if (AsmUtils.javaVersionSupportsAnnotations(fileVersion)) {
                    InstrumenterClassWriter writer = new InstrumenterClassWriter(NotNullInstrumenter.getAsmClassWriterFlags(fileVersion), finder);
                    NotNullInstrumenterClassVisitor instrumentingVisitor = new NotNullInstrumenterClassVisitor((ClassVisitor)writer, configuration);
                    classReader.accept((ClassVisitor)instrumentingVisitor, 0);
                    if (instrumentingVisitor.hasInstrumented()) {
                        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                            fileOutputStream.write(writer.toByteArray());
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
                break block29;
                {
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
            }
        }
        return false;
    }

    private static int getAsmClassWriterFlags(int version) {
        return AsmUtils.asmOpcodeToJavaVersion(version) >= 6 ? 2 : 1;
    }

    private static int getClassFileVersion(@NotNull ClassReader reader) {
        final int[] classFileVersion = new int[1];
        reader.accept(new ClassVisitor(327680){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                classFileVersion[0] = version;
            }
        }, 0);
        return classFileVersion[0];
    }
}

