/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.notNullVerification;

import com.intellij.compiler.notNullVerification.ThrowOnNullMethodVisitor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import se.eris.asm.AsmUtils;

class ImplicitThrowOnNullMethodVisitor
extends ThrowOnNullMethodVisitor {
    private final Set<String> nullableAnnotations;

    ImplicitThrowOnNullMethodVisitor(@Nullable MethodVisitor methodVisitor, @NotNull Type[] argumentTypes, @NotNull Type returnType, int access, @NotNull String methodName, @NotNull String className, @NotNull Set<String> nullableAnnotations, boolean isAnonymousClass) {
        super(327680, methodVisitor, argumentTypes, returnType, access, methodName, className, true, isAnonymousClass);
        this.nullableAnnotations = nullableAnnotations;
        this.addImplicitNotNulls();
    }

    private void addImplicitNotNulls() {
        int counter = 0;
        for (Type argumentType : this.argumentTypes) {
            if (AsmUtils.isReferenceType(argumentType)) {
                this.notNullParams.add(counter);
            }
            ++counter;
        }
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String annotation, boolean visible) {
        AnnotationVisitor av = this.mv.visitParameterAnnotation(parameter, annotation, visible);
        if (this.isParameterReferenceType(parameter)) {
            if (this.isNullableAnnotation(annotation)) {
                this.setNullable(parameter);
            }
        } else if (annotation.equals("Ljava/lang/Synthetic;")) {
            this.increaseSyntheticCount();
            this.setNullable(parameter);
        }
        return av;
    }

    private boolean setNullable(int parameter) {
        return this.notNullParams.remove((Object)parameter);
    }

    public AnnotationVisitor visitAnnotation(String annotation, boolean visible) {
        AnnotationVisitor av = this.mv.visitAnnotation(annotation, visible);
        if (this.isReturnReferenceType() && this.isNullableAnnotation(annotation)) {
            this.isReturnNotNull = false;
        }
        return av;
    }

    @Override
    @NotNull
    protected String notNullCause() {
        return "Implicit NotNull";
    }

    public void visitLocalVariable(String name, String description, String signature, Label start, Label end, int index) {
        this.mv.visitLocalVariable(name, description, signature, this.isParameter(index) && this.startGeneratedCodeLabel != null ? this.startGeneratedCodeLabel : start, end, index);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        try {
            super.visitMaxs(maxStack, maxLocals);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("visitMaxs processing failed for method " + this.methodName + ": " + e.getMessage());
        }
    }

    private boolean isNullableAnnotation(@NotNull String annotation) {
        return this.nullableAnnotations.contains(annotation);
    }
}

