/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.notNullVerification;

import com.intellij.compiler.notNullVerification.AnnotationThrowOnNullMethodVisitor;
import com.intellij.compiler.notNullVerification.ImplicitThrowOnNullMethodVisitor;
import com.intellij.compiler.notNullVerification.ThrowOnNullMethodVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import se.eris.lang.LangUtils;
import se.eris.notnull.Configuration;
import se.eris.notnull.ImplicitNotNull;

public class NotNullInstrumenterClassVisitor
extends ClassVisitor {
    private final Set<String> notnull;
    private final Set<String> nullable;
    private final Collection<ThrowOnNullMethodVisitor> methodVisitors = new ArrayList<ThrowOnNullMethodVisitor>();
    private String className;
    private boolean isAnonymous = false;
    private boolean classAnnotatedImplicit = false;
    @NotNull
    private final Configuration configuration;

    public NotNullInstrumenterClassVisitor(@NotNull ClassVisitor classVisitor, @NotNull Configuration configuration) {
        super(327680, classVisitor);
        this.configuration = configuration;
        this.notnull = this.convertToClassName(configuration.getNotNullAnnotations());
        this.nullable = this.convertToClassName(configuration.getNullableAnnotations());
    }

    @NotNull
    private Set<String> convertToClassName(@NotNull Iterable<String> annotations) {
        HashSet<String> converted = new HashSet<String>();
        for (String annotation : annotations) {
            converted.add(LangUtils.convertToJavaClassName(annotation));
        }
        return converted;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = name;
    }

    public void visitInnerClass(String name, String outer, String innerName, int access) {
        super.visitInnerClass(name, outer, innerName, access);
        if (name.equals(this.className)) {
            this.isAnonymous = innerName == null;
        }
    }

    @NotNull
    public MethodVisitor visitMethod(int access, @NotNull String name, String desc, String signature, String[] exceptions) {
        Type[] argumentTypes = Type.getArgumentTypes((String)desc);
        Type returnType = Type.getReturnType((String)desc);
        MethodVisitor methodVisitor = this.cv.visitMethod(access, name, desc, signature, exceptions);
        ThrowOnNullMethodVisitor visitor = this.classAnnotatedImplicit || this.configuration.isImplicitInstrumentation(this.toClassName(this.className)) ? new ImplicitThrowOnNullMethodVisitor(methodVisitor, argumentTypes, returnType, access, name, this.className, this.nullable, this.isAnonymous) : new AnnotationThrowOnNullMethodVisitor(methodVisitor, argumentTypes, returnType, access, name, this.className, this.notnull, this.isAnonymous);
        this.methodVisitors.add(visitor);
        return visitor;
    }

    @NotNull
    private String toClassName(String className) {
        return className.replace('/', '.');
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (LangUtils.convertToJavaClassName(ImplicitNotNull.class.getName()).equals(desc)) {
            this.classAnnotatedImplicit = true;
        }
        return super.visitAnnotation(desc, visible);
    }

    public boolean hasInstrumented() {
        for (ThrowOnNullMethodVisitor methodVisitor : this.methodVisitors) {
            if (!methodVisitor.hasInstrumented()) continue;
            return true;
        }
        return false;
    }
}

