/*
 * Decompiled with CFR 0.152.
 */
package se.eris.asm;

import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;

public final class AsmUtils {
    public static final int JAVA_VERSION_5 = 5;
    public static final int JAVA_VERSION_6 = 6;

    private AsmUtils() {
    }

    public static boolean isReferenceType(@NotNull Type type) {
        int sort = type.getSort();
        return sort == 10 || sort == 9;
    }

    public static boolean javaVersionSupportsAnnotations(int opcodeVersion) {
        return AsmUtils.asmOpcodeToJavaVersion(opcodeVersion) >= 5;
    }

    public static int asmOpcodeToJavaVersion(int versionOpcode) {
        return versionOpcode % 196608 - 44;
    }
}

