/*
 * Decompiled with CFR 0.152.
 */
package se.eris.asm;

import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassInfo {
    private static final String[] EMPTY_ARRAY = new String[0];
    private final int version;
    private final int access;
    @NotNull
    private final String name;
    @Nullable
    private final String signature;
    @Nullable
    private final String superName;
    @NotNull
    private final String[] interfaces;

    public ClassInfo(int version, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        this.version = version;
        this.access = access;
        this.name = name;
        this.signature = signature;
        this.superName = superName;
        this.interfaces = interfaces == null ? EMPTY_ARRAY : interfaces;
    }

    public int getVersion() {
        return this.version;
    }

    public int getAccess() {
        return this.access;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getSignature() {
        return this.signature;
    }

    @Nullable
    public String getSuperName() {
        return this.superName;
    }

    @NotNull
    public String[] getInterfaces() {
        return this.interfaces;
    }

    public boolean isInterface() {
        return (this.access & 0x200) > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassInfo classInfo = (ClassInfo)o;
        if (this.version != classInfo.version) {
            return false;
        }
        if (this.access != classInfo.access) {
            return false;
        }
        if (!this.name.equals(classInfo.name)) {
            return false;
        }
        if (!Objects.equals(this.signature, classInfo.signature)) {
            return false;
        }
        if (this.superName != null ? !this.superName.equals(classInfo.superName) : classInfo.superName != null) {
            return false;
        }
        return Arrays.equals(this.interfaces, classInfo.interfaces);
    }

    public int hashCode() {
        int result = this.version;
        result = 31 * result + this.access;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.signature == null ? 0 : this.signature.hashCode());
        result = 31 * result + (this.superName != null ? this.superName.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.interfaces);
        return result;
    }

    public String toString() {
        return "ClassInfo{version=" + this.version + ", access=" + this.access + ", name='" + this.name + '\'' + ", signature='" + this.signature + '\'' + ", superName='" + this.superName + '\'' + ", interfaces=" + Arrays.toString(this.interfaces) + '}';
    }
}

