/*
 * Decompiled with CFR 0.152.
 */
package se.eris.util.string;

import java.util.ArrayList;
import java.util.List;
import se.eris.util.string.Replacement;
import se.eris.util.string.StringWorker;

public class StringReplacer {
    private final String prefix;
    private final String suffix;
    private final List<Replacement> replacements = new ArrayList<Replacement>();

    public static Builder init() {
        return Builder.init();
    }

    public StringReplacer(String prefix, List<Replacement> replacements, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.replacements.addAll(replacements);
    }

    public String apply(String s) {
        StringWorker worker = new StringWorker(s);
        worker.insert(this.prefix);
        worker.replaceInOrder(this.replacements);
        worker.insert(this.suffix);
        return worker.toString();
    }

    public static class Builder {
        private String prefix = "";
        private String suffix = "";
        private final List<Replacement> replacements = new ArrayList<Replacement>();

        public static Builder init() {
            return new Builder();
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public Builder add(Replacement replacement) {
            this.replacements.add(replacement);
            return this;
        }

        public Builder add(String replace, String with) {
            return this.add(new Replacement(replace, with));
        }

        public StringReplacer build() {
            return new StringReplacer(this.prefix, this.replacements, this.suffix);
        }
    }
}

