/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import com.intellij.compiler.instrumentation.InstrumenterClassWriter;
import com.intellij.compiler.notNullVerification.NotNullInstrumenterClassVisitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import se.eris.asm.AsmUtils;
import se.eris.maven.LogWrapper;
import se.eris.notnull.Configuration;
import se.eris.notnull.InstrumentExecutionException;
import se.eris.util.ClassFileUtils;

public class NotNullInstrumenter {
    private static final int NO_FLAGS = 0;
    @NotNull
    private final LogWrapper logger;

    public NotNullInstrumenter(@NotNull LogWrapper logWrapper) {
        this.logger = logWrapper;
    }

    public int instrument(Path classesDirectory, Configuration configuration, @NotNull List<URL> urls) {
        Set<File> classFiles = ClassFileUtils.getClassFiles(classesDirectory);
        return this.instrument(classFiles, configuration, urls);
    }

    public int instrument(Set<File> classFiles, Configuration configuration, @NotNull List<URL> urls) {
        InstrumentationClassFinder finder = new InstrumentationClassFinder(urls.toArray(new URL[0]));
        return this.instrumentDirectoryRecursive(finder, configuration, classFiles);
    }

    private int instrumentDirectoryRecursive(@NotNull InstrumentationClassFinder finder, Configuration configuration, Set<File> classFiles) {
        int instrumentedCounter = 0;
        for (File file : classFiles) {
            instrumentedCounter += this.instrumentFile(file, finder, configuration);
        }
        return instrumentedCounter;
    }

    private int instrumentFile(@NotNull File file, @NotNull InstrumentationClassFinder finder, Configuration configuration) {
        this.logger.debug("Adding NotNull assertions to " + file.getPath());
        try {
            return NotNullInstrumenter.instrumentClass(file, finder, configuration) ? 1 : 0;
        }
        catch (IOException | RuntimeException e) {
            throw new InstrumentExecutionException("NotNull instrumentation failed for " + file.getPath(), e);
        }
    }

    private static boolean instrumentClass(@NotNull File file, @NotNull InstrumentationClassFinder finder, Configuration configuration) throws IOException {
        block10: {
            try (FileInputStream inputStream = new FileInputStream(file);){
                boolean bl;
                ClassReader classReader = new ClassReader((InputStream)inputStream);
                int fileVersion = NotNullInstrumenter.getClassFileVersion(classReader);
                if (!AsmUtils.javaVersionSupportsAnnotations(fileVersion)) break block10;
                InstrumenterClassWriter writer = new InstrumenterClassWriter(NotNullInstrumenter.getAsmClassWriterFlags(fileVersion), finder);
                NotNullInstrumenterClassVisitor instrumentingVisitor = new NotNullInstrumenterClassVisitor((ClassVisitor)writer, configuration);
                classReader.accept((ClassVisitor)instrumentingVisitor, 0);
                if (!instrumentingVisitor.hasInstrumented()) break block10;
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    fileOutputStream.write(writer.toByteArray());
                    bl = true;
                }
                return bl;
            }
        }
        return false;
    }

    private static int getAsmClassWriterFlags(int version) {
        return AsmUtils.asmOpcodeToJavaVersion(version) >= 6 ? 2 : 1;
    }

    private static int getClassFileVersion(@NotNull ClassReader reader) {
        final int[] classFileVersion = new int[1];
        reader.accept(new ClassVisitor(589824){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                classFileVersion[0] = version;
            }
        }, 0);
        return classFileVersion[0];
    }
}

