/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.instrumentation;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import se.eris.notnull.instrumentation.Resource;

class ClassFinderClasspath {
    private static final String FILE_PROTOCOL = "file";
    private final Stack<URL> myUrls = new Stack();
    private final List<Loader> myLoaders = new ArrayList<Loader>();
    private final Map<URL, Loader> myLoadersMap = new HashMap<URL, Loader>();

    ClassFinderClasspath(URL[] urls) {
        for (int i = urls.length - 1; i >= 0; --i) {
            this.myUrls.push(urls[i]);
        }
    }

    private static String unescapePercentSequences(String s) {
        if (s.indexOf(37) == -1) {
            return s;
        }
        int len = s.length();
        StringBuilder decoded = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '%') {
                ArrayList<Integer> bytes = new ArrayList<Integer>();
                while (s.charAt(i) == '%' && i + 2 < len) {
                    int d1 = ClassFinderClasspath.decode(s.charAt(i + 1));
                    int d2 = ClassFinderClasspath.decode(s.charAt(i + 2));
                    if (d1 == -1 || d2 == -1) break;
                    bytes.add(d1 << 4 | d2);
                    i += 3;
                }
                if (!bytes.isEmpty()) {
                    byte[] bytesArray = new byte[bytes.size()];
                    for (int j = 0; j < bytes.size(); ++j) {
                        bytesArray[j] = (byte)((Integer)bytes.get(j)).intValue();
                    }
                    decoded.append(new String(bytesArray, StandardCharsets.UTF_8));
                    continue;
                }
            }
            decoded.append(c);
            ++i;
        }
        return decoded.toString();
    }

    @Contract(pure=true)
    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    @Nullable
    Resource getResource(String s) {
        Loader loader;
        int i = 0;
        while ((loader = this.getLoader(i)) != null) {
            Resource resource = loader.getResource(s);
            if (resource != null) {
                return resource;
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private synchronized Loader getLoader(int i) {
        while (this.myLoaders.size() < i + 1) {
            Loader loader;
            URL url;
            Stack<URL> stack = this.myUrls;
            synchronized (stack) {
                if (this.myUrls.empty()) {
                    return null;
                }
                url = this.myUrls.pop();
            }
            if (this.myLoadersMap.containsKey(url)) continue;
            try {
                loader = this.getLoader(url);
                if (loader == null) {
                }
            }
            catch (IOException ioexception) {}
            continue;
            this.myLoaders.add(loader);
            this.myLoadersMap.put(url, loader);
        }
        return this.myLoaders.get(i);
    }

    @Nullable
    private Loader getLoader(URL url) throws IOException {
        String s;
        try {
            s = url.toURI().getSchemeSpecificPart();
        }
        catch (URISyntaxException thisShouldNotHappen) {
            thisShouldNotHappen.printStackTrace();
            s = url.getFile();
        }
        Loader loader = null;
        if (s != null && new File(s).isDirectory()) {
            if (FILE_PROTOCOL.equals(url.getProtocol())) {
                loader = new FileLoader(url);
            }
        } else {
            loader = new JarLoader(url);
        }
        return loader;
    }

    private static abstract class Loader {
        static final String JAR_PROTOCOL = "jar";
        static final String FILE_PROTOCOL = "file";
        private final URL myURL;

        Loader(URL url) {
            this.myURL = url;
        }

        URL getBaseURL() {
            return this.myURL;
        }

        public abstract Resource getResource(String var1);
    }

    private static class FileLoader
    extends Loader {
        private final File rootDir;

        FileLoader(URL url) {
            super(url);
            if (!ClassFinderClasspath.FILE_PROTOCOL.equals(url.getProtocol())) {
                throw new IllegalArgumentException(this.getClass().getSimpleName() + " requires the " + ClassFinderClasspath.FILE_PROTOCOL + " protocol. (url: " + url + ")");
            }
            String s = ClassFinderClasspath.unescapePercentSequences(url.getFile().replace('/', File.separatorChar));
            this.rootDir = new File(s);
        }

        @Override
        @Nullable
        public Resource getResource(String name) {
            try {
                URL url = new URL(this.getBaseURL(), name);
                if (!url.getFile().startsWith(this.getBaseURL().getFile())) {
                    return null;
                }
            }
            catch (Exception url) {
                // empty catch block
            }
            File file = new File(this.rootDir, name.replace('/', File.separatorChar));
            if (file.exists()) {
                return new FileResource(file);
            }
            return null;
        }

        public String toString() {
            return "FileLoader [" + this.rootDir + "]";
        }

        private static class FileResource
        extends Resource {
            private final File file;

            FileResource(File file) {
                this.file = file;
            }

            @Override
            @NotNull
            public InputStream getInputStream() throws IOException {
                return new BufferedInputStream(new FileInputStream(this.file));
            }

            public String toString() {
                return this.file.getAbsolutePath();
            }
        }
    }

    private static class JarLoader
    extends Loader {
        private final URL myURL;
        private ZipFile myZipFile;

        JarLoader(URL url) throws IOException {
            super(new URL("jar", "", -1, url + "!/"));
            this.myURL = url;
        }

        @Nullable
        private ZipFile acquireZipFile() throws IOException {
            ZipFile zipFile = this.myZipFile;
            if (zipFile == null) {
                this.myZipFile = zipFile = this.doGetZipFile();
            }
            return zipFile;
        }

        @Nullable
        private ZipFile doGetZipFile() throws IOException {
            if (ClassFinderClasspath.FILE_PROTOCOL.equals(this.myURL.getProtocol())) {
                String s = ClassFinderClasspath.unescapePercentSequences(this.myURL.getFile().replace('/', File.separatorChar));
                if (!new File(s).exists()) {
                    throw new FileNotFoundException(s);
                }
                return new ZipFile(s);
            }
            return null;
        }

        @Override
        @Nullable
        public Resource getResource(String name) {
            try {
                ZipEntry entry;
                ZipFile file = this.acquireZipFile();
                if (file != null && (entry = file.getEntry(name)) != null) {
                    return new JarResource(entry);
                }
            }
            catch (Exception e) {
                return null;
            }
            return null;
        }

        public String toString() {
            return "JarLoader [" + this.myURL + "]";
        }

        private class JarResource
        extends Resource {
            private final ZipEntry zipEntry;

            JarResource(ZipEntry zipEntry) {
                this.zipEntry = zipEntry;
            }

            @Override
            @Nullable
            public InputStream getInputStream() {
                try {
                    ZipFile file = JarLoader.this.acquireZipFile();
                    if (file == null) {
                        return null;
                    }
                    InputStream inputStream = file.getInputStream(this.zipEntry);
                    if (inputStream == null) {
                        return null;
                    }
                    return new FilterInputStream(inputStream){};
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
    }
}

