/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.notNullVerification;

import com.intellij.compiler.notNullVerification.ThrowOnNullMethodVisitor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import se.eris.asm.ClassInfo;

class AnnotationThrowOnNullMethodVisitor
extends ThrowOnNullMethodVisitor {
    private final Set<String> notNullAnnotations;

    AnnotationThrowOnNullMethodVisitor(@Nullable MethodVisitor methodVisitor, @NotNull Type[] argumentTypes, @NotNull Type returnType, int access, @NotNull String methodName, @NotNull ClassInfo classInfo, @NotNull Set<String> notNullAnnotations, Boolean isAnonymous) {
        super(methodVisitor, argumentTypes, returnType, access, methodName, classInfo, false, isAnonymous);
        this.notNullAnnotations = notNullAnnotations;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String annotation, boolean visible) {
        AnnotationVisitor av = this.mv.visitParameterAnnotation(parameter, annotation, visible);
        if (this.isParameterReferenceType(parameter) && this.isNotNullAnnotation(annotation)) {
            this.notNullParams.add(parameter);
        } else if (annotation.equals("Ljava/lang/Synthetic;")) {
            this.increaseSyntheticCount();
        }
        return av;
    }

    public AnnotationVisitor visitAnnotation(String annotation, boolean visible) {
        AnnotationVisitor av = this.mv.visitAnnotation(annotation, visible);
        if (this.isReturnReferenceType() && this.isNotNullAnnotation(annotation)) {
            this.isReturnNotNull = true;
        }
        return av;
    }

    @Override
    @NotNull
    protected String notNullCause() {
        return "NotNull annotated";
    }

    public void visitLocalVariable(String name, String description, String signature, Label start, Label end, int index) {
        this.mv.visitLocalVariable(name, description, signature, this.isParameter(index) && this.startGeneratedCodeLabel != null ? this.startGeneratedCodeLabel : start, end, index);
    }

    private boolean isNotNullAnnotation(@NotNull String annotation) {
        return this.notNullAnnotations.contains(annotation);
    }
}

