/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.notNullVerification;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import se.eris.asm.AsmUtils;
import se.eris.asm.ClassInfo;
import se.eris.lang.LangUtils;

public abstract class ThrowOnNullMethodVisitor
extends MethodVisitor {
    static final String LJAVA_LANG_SYNTHETIC_ANNO = "Ljava/lang/Synthetic;";
    private static final String IAE_CLASS_NAME = "java/lang/IllegalArgumentException";
    private static final String ISE_CLASS_NAME = "java/lang/IllegalStateException";
    private static final String CONSTRUCTOR_NAME = "<init>";
    final Type[] argumentTypes;
    private final int methodAccess;
    private final Type returnType;
    final String methodName;
    private final ClassInfo classInfo;
    boolean isReturnNotNull;
    @Nullable
    private final Boolean isAnonymousClass;
    int syntheticCount;
    final List<Integer> notNullParams;
    private boolean instrumented;
    Label startGeneratedCodeLabel;
    private List<String> parameterNames = null;

    ThrowOnNullMethodVisitor(@Nullable MethodVisitor mv, Type[] argumentTypes, Type returnType, int methodAccess, String methodName, ClassInfo classInfo, boolean isReturnNotNull, @Nullable Boolean isAnonymousClass) {
        super(589824, mv);
        this.argumentTypes = argumentTypes;
        this.methodAccess = methodAccess;
        this.returnType = returnType;
        this.methodName = methodName;
        this.classInfo = classInfo;
        this.isReturnNotNull = isReturnNotNull;
        this.isAnonymousClass = isAnonymousClass;
        if (this.isConstructor()) {
            this.syntheticCount += isAnonymousClass != null ? 1 : 0;
            this.syntheticCount += classInfo.isEnum() ? 2 : 0;
        }
        this.notNullParams = new ArrayList<Integer>();
        this.instrumented = false;
    }

    private void setInstrumented() {
        this.instrumented = true;
    }

    public void visitParameter(String name, int access) {
        if (this.parameterNames == null) {
            this.parameterNames = new ArrayList<String>(this.argumentTypes.length);
        }
        this.parameterNames.add(name);
        if (this.mv != null) {
            this.mv.visitParameter(name, access);
        }
    }

    public void visitInsn(int opcode) {
        if (this.shouldInclude() && opcode == 176 && this.isReturnNotNull && !this.isReturnVoidReferenceType()) {
            this.mv.visitInsn(89);
            Label skipLabel = new Label();
            this.mv.visitJumpInsn(199, skipLabel);
            this.generateThrow(ISE_CLASS_NAME, "NotNull method " + this.classInfo.getName() + "." + this.methodName + " must not return null", skipLabel);
        }
        this.mv.visitInsn(opcode);
    }

    boolean hasInstrumented() {
        return this.instrumented;
    }

    private boolean isStatic() {
        return (this.methodAccess & 8) != 0;
    }

    boolean isParameter(int index) {
        return this.isStatic() ? index < this.argumentTypes.length : index <= this.argumentTypes.length;
    }

    public void visitCode() {
        if (this.shouldInclude()) {
            if (!this.notNullParams.isEmpty()) {
                this.startGeneratedCodeLabel = new Label();
                this.mv.visitLabel(this.startGeneratedCodeLabel);
            }
            for (Integer notNullParam : this.notNullParams) {
                int var = (this.methodAccess & 8) == 0 ? 1 : 0;
                for (int i = 0; i < notNullParam + this.syntheticCount; ++i) {
                    var += this.argumentTypes[i].getSize();
                }
                this.mv.visitVarInsn(25, var);
                Label end = new Label();
                this.mv.visitJumpInsn(199, end);
                this.generateThrow(IAE_CLASS_NAME, this.getThrowMessage(notNullParam), end);
            }
        }
        this.mv.visitCode();
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        try {
            super.visitMaxs(maxStack, maxLocals);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("visitMaxs processing failed for method " + this.methodName + ": " + e.getMessage());
        }
    }

    private boolean shouldInclude() {
        return !this.shouldSkip();
    }

    private boolean shouldSkip() {
        return this.isSynthetic() || this.isAnonymousClassConstructor() || this.isEqualsMethod();
    }

    private boolean isAnonymousClassConstructor() {
        return this.isAnonymousClass != null && this.isAnonymousClass != false && this.isConstructor();
    }

    private boolean isConstructor() {
        return CONSTRUCTOR_NAME.equals(this.methodName);
    }

    private boolean isSynthetic() {
        return (this.methodAccess & 0x1000) != 0;
    }

    private boolean isEqualsMethod() {
        return "equals".equals(this.methodName) && this.returnType.equals((Object)Type.BOOLEAN_TYPE) && this.argumentTypes.length == 1 && this.argumentTypes[0].getSort() == 10;
    }

    private void generateThrow(@NotNull String exceptionClass, @NotNull String description, @NotNull Label end) {
        String exceptionParamClass = "(" + LangUtils.convertToJavaClassName(String.class.getName()) + ")V";
        this.mv.visitTypeInsn(187, exceptionClass);
        this.mv.visitInsn(89);
        this.mv.visitLdcInsn((Object)description);
        this.mv.visitMethodInsn(183, exceptionClass, CONSTRUCTOR_NAME, exceptionParamClass, false);
        this.mv.visitInsn(191);
        this.mv.visitLabel(end);
        this.setInstrumented();
    }

    boolean isReturnReferenceType() {
        return AsmUtils.isReferenceType(this.returnType);
    }

    boolean isReturnVoidReferenceType() {
        return this.returnType.getClassName().equals(Void.class.getName());
    }

    boolean isParameterReferenceType(int parameter) {
        return AsmUtils.isReferenceType(this.getArgumentType(parameter));
    }

    private Type getArgumentType(int parameter) {
        int argumentNumber = parameter + this.syntheticCount;
        return this.argumentTypes[argumentNumber];
    }

    @NotNull
    private String getThrowMessage(int parameterNumber) {
        String pname = this.parameterNames == null || this.parameterNames.size() <= parameterNumber + this.syntheticCount ? "" : String.format(" (parameter '%s')", this.parameterNames.get(parameterNumber + this.syntheticCount));
        return String.format("%s argument %d%s of %s.%s must not be null", this.notNullCause(), parameterNumber, pname, this.classInfo.getName(), this.methodName);
    }

    @NotNull
    protected abstract String notNullCause();

    void increaseSyntheticCount() {
        ++this.syntheticCount;
    }
}

