/*
 * Decompiled with CFR 0.152.
 */
package se.fishtank.css.selectors.dom.internal;

import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.fishtank.css.selectors.NodeSelectorException;
import se.fishtank.css.selectors.dom.DOMHelper;
import se.fishtank.css.selectors.dom.internal.NodeTraversalChecker;
import se.fishtank.css.selectors.specifier.PseudoNthSpecifier;
import se.fishtank.css.util.Assert;

public class PseudoNthSpecifierChecker
extends NodeTraversalChecker {
    private final PseudoNthSpecifier specifier;
    private Set<Node> nodes;
    private Set<Node> result;

    public PseudoNthSpecifierChecker(PseudoNthSpecifier specifier) {
        Assert.notNull(specifier, "specifier is null!");
        this.specifier = specifier;
    }

    @Override
    public Set<Node> check(Set<Node> nodes, Node root) throws NodeSelectorException {
        Assert.notNull(nodes, "nodes is null!");
        this.nodes = nodes;
        this.result = new LinkedHashSet<Node>();
        String value = this.specifier.getValue();
        if ("nth-child".equals(value)) {
            this.addNthChild();
        } else if ("nth-last-child".equals(value)) {
            this.addNthLastChild();
        } else if ("nth-of-type".equals(value)) {
            this.addNthOfType();
        } else if ("nth-last-of-type".equals(value)) {
            this.addNthLastOfType();
        } else {
            throw new NodeSelectorException("Unknown pseudo nth class: " + value);
        }
        return this.result;
    }

    private void addNthChild() {
        for (Node node : this.nodes) {
            int count = 1;
            Element n = DOMHelper.getPreviousSiblingElement(node);
            while (n != null) {
                ++count;
                n = DOMHelper.getPreviousSiblingElement(n);
            }
            if (!this.specifier.isMatch(count)) continue;
            this.result.add(node);
        }
    }

    private void addNthLastChild() {
        for (Node node : this.nodes) {
            int count = 1;
            Element n = DOMHelper.getNextSiblingElement(node);
            while (n != null) {
                ++count;
                n = DOMHelper.getNextSiblingElement(n);
            }
            if (!this.specifier.isMatch(count)) continue;
            this.result.add(node);
        }
    }

    private void addNthOfType() {
        for (Node node : this.nodes) {
            int count = 1;
            Element n = DOMHelper.getPreviousSiblingElement(node);
            while (n != null) {
                if (n.getNodeName().equals(node.getNodeName())) {
                    ++count;
                }
                n = DOMHelper.getPreviousSiblingElement(n);
            }
            if (!this.specifier.isMatch(count)) continue;
            this.result.add(node);
        }
    }

    private void addNthLastOfType() {
        for (Node node : this.nodes) {
            int count = 1;
            Element n = DOMHelper.getNextSiblingElement(node);
            while (n != null) {
                if (n.getNodeName().equals(node.getNodeName())) {
                    ++count;
                }
                n = DOMHelper.getNextSiblingElement(n);
            }
            if (!this.specifier.isMatch(count)) continue;
            this.result.add(node);
        }
    }
}

