/*
 * Decompiled with CFR 0.152.
 */
package se.fishtank.css.selectors;

import java.util.LinkedList;
import java.util.List;
import se.fishtank.css.selectors.dom.DOMNode;
import se.fishtank.css.selectors.dom.Traversal;
import se.fishtank.css.selectors.dom.Visitor;
import se.fishtank.css.selectors.matching.SelectorMatcher;
import se.fishtank.css.selectors.matching.SimpleSelectorMatcher;
import se.fishtank.css.selectors.parser.ParserException;
import se.fishtank.css.selectors.parser.SelectorParser;
import se.fishtank.css.selectors.selector.Selector;
import se.fishtank.css.selectors.util.Reference;

public class Selectors<T, U extends DOMNode<U, T>> {
    private final U rootNode;
    private final SelectorMatcher<U> selectorMatcher;

    public Selectors(U rootNode) {
        this(rootNode, null);
    }

    public Selectors(U rootNode, SimpleSelectorMatcher<U> simpleSelectorMatcher) {
        this.rootNode = rootNode;
        this.selectorMatcher = new SelectorMatcher<U>(simpleSelectorMatcher);
    }

    public U getRootNode() {
        return this.rootNode;
    }

    public T querySelector(final List<Selector> selectors) {
        Reference ref;
        block2: {
            ref = new Reference();
            final RuntimeException done = new RuntimeException();
            try {
                Traversal.traverseElements(this.rootNode, new Visitor<U>(){

                    @Override
                    public void visit(U node) {
                        if (Selectors.this.selectorMatcher.matchesSelectors(selectors, node)) {
                            ref.referent = node.getUnderlying();
                            throw done;
                        }
                    }
                });
            }
            catch (RuntimeException e) {
                if (e == done) break block2;
                throw e;
            }
        }
        return ref.referent;
    }

    public T querySelector(String selectors) throws ParserException {
        return this.querySelector(Selectors.parse(selectors));
    }

    public List<T> querySelectorAll(final List<Selector> selectors) {
        final LinkedList result = new LinkedList();
        Traversal.traverseElements(this.rootNode, new Visitor<U>(){

            @Override
            public void visit(U node) {
                if (Selectors.this.selectorMatcher.matchesSelectors(selectors, node)) {
                    result.add(node.getUnderlying());
                }
            }
        });
        return result;
    }

    public List<T> querySelectorAll(String selectors) throws ParserException {
        return this.querySelectorAll(Selectors.parse(selectors));
    }

    public static List<Selector> parse(String selectors) throws ParserException {
        return SelectorParser.parse(selectors);
    }
}

