/*
 * Decompiled with CFR 0.152.
 */
package se.fishtank.css.selectors.dom;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import se.fishtank.css.selectors.dom.DOMNode;

public class W3CNode
implements DOMNode<W3CNode, Node> {
    private final Node node;

    public W3CNode(Node node) {
        this.node = node;
    }

    @Override
    public Node getUnderlying() {
        return this.node;
    }

    @Override
    public DOMNode.Type getType() {
        switch (this.node.getNodeType()) {
            case 9: {
                return DOMNode.Type.DOCUMENT;
            }
            case 1: {
                return DOMNode.Type.ELEMENT;
            }
            case 3: {
                return DOMNode.Type.TEXT;
            }
        }
        return DOMNode.Type.OTHER;
    }

    @Override
    public String getData() {
        if (this.node.getNodeType() == 1) {
            return this.node.getNodeName();
        }
        return this.node.getNodeValue();
    }

    @Override
    public Map<String, String> getAttributes() {
        NamedNodeMap namedNodeMap = this.node.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        int len = namedNodeMap.getLength();
        for (int i = 0; i < len; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            attrs.put(attr.getName(), attr.getValue());
        }
        return attrs;
    }

    @Override
    public W3CNode getFirstChild() {
        return this.wrap(this.node.getFirstChild());
    }

    @Override
    public W3CNode getPreviousSibling() {
        return this.wrap(this.node.getPreviousSibling());
    }

    @Override
    public W3CNode getNextSibling() {
        return this.wrap(this.node.getNextSibling());
    }

    @Override
    public W3CNode getParentNode() {
        return this.wrap(this.node.getParentNode());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        W3CNode that = (W3CNode)other;
        return Objects.equals(this.node, that.node);
    }

    public int hashCode() {
        return Objects.hash(this.node);
    }

    private W3CNode wrap(Node n) {
        return n == null ? null : new W3CNode(n);
    }
}

