/*
 * Decompiled with CFR 0.152.
 */
package se.fishtank.css.selectors.matching;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import se.fishtank.css.selectors.dom.DOMNode;
import se.fishtank.css.selectors.matching.SimpleSelectorMatcher;
import se.fishtank.css.selectors.selector.AttributeSelector;
import se.fishtank.css.selectors.selector.Combinator;
import se.fishtank.css.selectors.selector.CompoundSelector;
import se.fishtank.css.selectors.selector.LocalNameSelector;
import se.fishtank.css.selectors.selector.PseudoClassSelector;
import se.fishtank.css.selectors.selector.PseudoNegationSelector;
import se.fishtank.css.selectors.selector.PseudoNthSelector;
import se.fishtank.css.selectors.selector.Selector;
import se.fishtank.css.selectors.selector.SimpleSelector;

public class SelectorMatcher<T extends DOMNode<T, ?>> {
    public static final Pattern SPACE_REGEX = Pattern.compile("[ \\t\\r\\n\\f]+");
    private final SimpleSelectorMatcher<T> simpleSelectorMatcher;

    public SelectorMatcher(SimpleSelectorMatcher<T> simpleSelectorMatcher) {
        this.simpleSelectorMatcher = simpleSelectorMatcher;
    }

    public SelectorMatcher() {
        this.simpleSelectorMatcher = null;
    }

    public boolean matchesSelectors(List<Selector> selectors, T node) {
        for (Selector selector : selectors) {
            if (!this.matchesSelector(selector, node)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesSelector(Selector selector, T node) {
        return selector.pseudoElement == null && this.matchesCompoundSelector(selector.compoundSelector, node) == MatchingResult.MATCHED;
    }

    public boolean matchesSimpleSelector(SimpleSelector selector, T node) {
        if (node.getType() == DOMNode.Type.DOCUMENT) {
            for (node = node.getFirstChild(); node != null && node.getType() != DOMNode.Type.ELEMENT; node = node.getNextSibling()) {
            }
        }
        if (node == null || node.getType() != DOMNode.Type.ELEMENT) {
            return false;
        }
        if (selector instanceof LocalNameSelector) {
            return node.getData().equalsIgnoreCase(((LocalNameSelector)selector).name);
        }
        if (selector instanceof AttributeSelector) {
            return this.matchesAttributeSelector((AttributeSelector)selector, node);
        }
        if (selector instanceof PseudoNegationSelector) {
            return !this.matchesSimpleSelector(((PseudoNegationSelector)selector).selector, node);
        }
        if (selector instanceof PseudoClassSelector ? this.matchesPseudoClassSelector((PseudoClassSelector)selector, node) : selector instanceof PseudoNthSelector && this.matchesPseudoNthSelector((PseudoNthSelector)selector, node)) {
            return true;
        }
        return this.simpleSelectorMatcher != null && this.simpleSelectorMatcher.matches(selector, node);
    }

    private MatchingResult matchesCompoundSelector(CompoundSelector selector, T node) {
        for (SimpleSelector simpleSelector : selector.simpleSelectors) {
            if (this.matchesSimpleSelector(simpleSelector, node)) continue;
            return MatchingResult.RESTART_FROM_CLOSEST_LATER_SIBLING;
        }
        if (selector.previous == null) {
            return MatchingResult.MATCHED;
        }
        boolean siblings = false;
        MatchingResult candidateNotFound = MatchingResult.NOT_MATCHED;
        switch ((Combinator)((Object)selector.previous.first)) {
            case NEXT_SIBLING: 
            case LATER_SIBLING: {
                siblings = true;
                candidateNotFound = MatchingResult.RESTART_FROM_CLOSEST_DESCENDANT;
            }
        }
        Object nextNode;
        while ((nextNode = siblings ? node.getPreviousSibling() : node.getParentNode()) != null) {
            node = nextNode;
            if (node.getType() != DOMNode.Type.ELEMENT) continue;
            MatchingResult result = this.matchesCompoundSelector((CompoundSelector)selector.previous.second, node);
            if (result == MatchingResult.MATCHED || result == MatchingResult.NOT_MATCHED) {
                return result;
            }
            switch ((Combinator)((Object)selector.previous.first)) {
                case CHILD: {
                    return MatchingResult.RESTART_FROM_CLOSEST_DESCENDANT;
                }
                case NEXT_SIBLING: {
                    return result;
                }
                case LATER_SIBLING: {
                    if (result != MatchingResult.RESTART_FROM_CLOSEST_DESCENDANT) break;
                    return result;
                }
            }
        }
        return candidateNotFound;
    }

    private boolean matchesAttributeSelector(AttributeSelector selector, T node) {
        Map<String, String> attributes = node.getAttributes();
        if (attributes == null) {
            return false;
        }
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (!entry.getKey().equals(selector.name)) continue;
            switch (selector.match) {
                case EXISTS: {
                    return true;
                }
                case EQUALS: {
                    return entry.getValue().equals(selector.value);
                }
                case INCLUDES: {
                    for (String v : SPACE_REGEX.split(entry.getValue())) {
                        if (!v.equals(selector.value)) continue;
                        return true;
                    }
                    return false;
                }
                case BEGINS: {
                    return entry.getValue().startsWith(selector.value);
                }
                case ENDS: {
                    return entry.getValue().endsWith(selector.value);
                }
                case CONTAINS: {
                    return entry.getValue().contains(selector.value);
                }
                case HYPHENS: {
                    String v = entry.getValue();
                    return v.equals(selector.value) || v.startsWith(selector.value + "-");
                }
            }
            return false;
        }
        return false;
    }

    private boolean matchesPseudoClassSelector(PseudoClassSelector selector, T node) {
        switch (selector.value) {
            case "first-child": {
                return this.matchesFirstOrLastChild(node, true);
            }
            case "last-child": {
                return this.matchesFirstOrLastChild(node, false);
            }
            case "only-child": {
                return this.matchesFirstOrLastChild(node, true) && this.matchesFirstOrLastChild(node, false);
            }
            case "first-of-type": {
                return this.matchesNthChild(node, 0, 1, true, false);
            }
            case "last-of-type": {
                return this.matchesNthChild(node, 0, 1, true, true);
            }
            case "only-of-type": {
                return this.matchesNthChild(node, 0, 1, true, false) && this.matchesNthChild(node, 0, 1, true, true);
            }
            case "root": {
                Object parentNode = node.getParentNode();
                return parentNode != null && parentNode.getType() == DOMNode.Type.DOCUMENT;
            }
            case "empty": {
                block24: for (Object child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    switch (child.getType()) {
                        case ELEMENT: {
                            return false;
                        }
                        case TEXT: {
                            String data = child.getData();
                            if (data == null || data.isEmpty()) continue block24;
                            return false;
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean matchesPseudoNthSelector(PseudoNthSelector selector, T node) {
        switch (selector.name) {
            case "nth-child": {
                return this.matchesNthChild(node, selector.a, selector.b, false, false);
            }
            case "nth-last-child": {
                return this.matchesNthChild(node, selector.a, selector.b, false, true);
            }
            case "nth-of-type": {
                return this.matchesNthChild(node, selector.a, selector.b, true, false);
            }
            case "nth-last-of-type": {
                return this.matchesNthChild(node, selector.a, selector.b, true, true);
            }
        }
        return false;
    }

    private boolean matchesFirstOrLastChild(T node, boolean first) {
        while (true) {
            Object n;
            if ((n = first ? node.getPreviousSibling() : node.getNextSibling()) == null) {
                n = node.getParentNode();
                return n != null && n.getType() != DOMNode.Type.DOCUMENT;
            }
            if (n.getType() == DOMNode.Type.ELEMENT) {
                return false;
            }
            node = n;
        }
    }

    private boolean matchesNthChild(T node, int a, int b, boolean isOfType, boolean fromEnd) {
        Object sibling;
        Object parentNode = node.getParentNode();
        if (parentNode == null || parentNode.getType() == DOMNode.Type.DOCUMENT) {
            return false;
        }
        T n = node;
        int i = 1;
        while ((sibling = fromEnd ? n.getNextSibling() : n.getPreviousSibling()) != null) {
            n = sibling;
            if (n.getType() != DOMNode.Type.ELEMENT) continue;
            if (isOfType) {
                if (!node.getData().equals(n.getData())) continue;
                ++i;
                continue;
            }
            ++i;
        }
        if (a == 0) {
            return b == i;
        }
        return (i - b) / a >= 0 && (i - b) % a == 0;
    }

    private static enum MatchingResult {
        MATCHED,
        NOT_MATCHED,
        RESTART_FROM_CLOSEST_DESCENDANT,
        RESTART_FROM_CLOSEST_LATER_SIBLING;

    }
}

