/*
 * Decompiled with CFR 0.152.
 */
package se.fishtank.css.selectors.parser;

import se.fishtank.css.selectors.parser.ParserException;
import se.fishtank.css.selectors.tokenizer.Token;
import se.fishtank.css.selectors.tokenizer.TokenType;
import se.fishtank.css.selectors.tokenizer.Tokenizer;
import se.fishtank.css.selectors.util.Pair;

public class NthParser {
    private final Tokenizer tokenizer;
    private final ParserException error;

    private NthParser(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
        this.error = new ParserException("Invalid nth arguments at position " + tokenizer.getPosition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Pair<Integer, Integer> parse(Tokenizer tokenizer) {
        NthParser parser = new NthParser(tokenizer);
        try {
            Token token = parser.skipWhitespace();
            switch (token.type) {
                case NUMBER: {
                    Token.Number n = (Token.Number)token;
                    if (!n.integer) throw parser.error;
                    if (parser.matchClosingParen()) return new Pair<Integer, Integer>(0, Integer.parseInt(n.value));
                    throw parser.error;
                }
                case DIMENSION: {
                    Token.Dimension d = (Token.Dimension)token;
                    if (!d.integer) {
                        throw parser.error;
                    }
                    int a = Integer.parseInt(d.value);
                    String str = d.unit.toLowerCase();
                    switch (str) {
                        case "n": {
                            return new Pair<Integer, Integer>(a, parser.parseB());
                        }
                        case "n-": {
                            return new Pair<Integer, Integer>(a, parser.parseSignlessB(-1));
                        }
                    }
                    try {
                        Object object = new Pair<Integer, Integer>(a, parser.parseNDashDigits(str));
                        return object;
                    }
                    finally {
                        parser.mustMatchClosingParen();
                    }
                }
                case IDENT: {
                    String str = token.value.toLowerCase();
                    switch (str) {
                        case "even": {
                            parser.mustMatchClosingParen();
                            return new Pair<Integer, Integer>(2, 0);
                        }
                        case "odd": {
                            parser.mustMatchClosingParen();
                            return new Pair<Integer, Integer>(2, 1);
                        }
                        case "n": {
                            return new Pair<Integer, Integer>(1, parser.parseB());
                        }
                        case "-n": {
                            return new Pair<Integer, Integer>(-1, parser.parseB());
                        }
                        case "n-": {
                            return new Pair<Integer, Integer>(1, parser.parseSignlessB(-1));
                        }
                        case "-n-": {
                            return new Pair<Integer, Integer>(-1, parser.parseSignlessB(-1));
                        }
                    }
                    try {
                        Pair<Integer, Integer> pair;
                        if (str.startsWith("-")) {
                            pair = new Pair<Integer, Integer>(-1, parser.parseNDashDigits(str.substring(1)));
                            return pair;
                        }
                        pair = new Pair<Integer, Integer>(1, parser.parseNDashDigits(str));
                        return pair;
                    }
                    finally {
                        parser.mustMatchClosingParen();
                    }
                }
                case DELIM: {
                    if (!"+".equals(token.value)) {
                        throw parser.error;
                    }
                    token = tokenizer.nextToken();
                    if (token.type != TokenType.IDENT) {
                        throw parser.error;
                    }
                    String str = token.value.toLowerCase();
                    switch (str) {
                        case "n": {
                            return new Pair<Integer, Integer>(1, parser.parseB());
                        }
                        case "n-": {
                            return new Pair<Integer, Integer>(1, parser.parseSignlessB(-1));
                        }
                    }
                    try {
                        Object object = new Pair<Integer, Integer>(1, parser.parseNDashDigits(str));
                        return object;
                    }
                    finally {
                        parser.mustMatchClosingParen();
                    }
                }
            }
            throw parser.error;
        }
        catch (NumberFormatException e) {
            throw parser.error;
        }
    }

    private int parseB() {
        Token token = this.skipWhitespace();
        switch (token.type) {
            case RIGHT_PAREN: {
                return 0;
            }
            case DELIM: {
                switch (token.value) {
                    case "+": {
                        return this.parseSignlessB(1);
                    }
                    case "-": {
                        return this.parseSignlessB(-1);
                    }
                }
                break;
            }
            case NUMBER: {
                Token.Number n = (Token.Number)token;
                if (!n.integer || !this.hasSignPrefix(n.value) || !this.matchClosingParen()) break;
                return Integer.parseInt(n.value);
            }
        }
        throw this.error;
    }

    private int parseSignlessB(int sign) {
        Token token = this.skipWhitespace();
        if (token instanceof Token.Number) {
            Token.Number n = (Token.Number)token;
            if (n.integer && !this.hasSignPrefix(n.value) && this.matchClosingParen()) {
                return Integer.parseInt(n.value) * sign;
            }
        }
        throw this.error;
    }

    private int parseNDashDigits(String str) {
        if (str.length() >= 3 && str.startsWith("n-")) {
            return Integer.parseInt(str.substring(1));
        }
        throw this.error;
    }

    private boolean hasSignPrefix(String str) {
        char c = str.charAt(0);
        return c == '+' || c == '-';
    }

    private boolean matchClosingParen() {
        return this.skipWhitespace().type == TokenType.RIGHT_PAREN;
    }

    private void mustMatchClosingParen() {
        if (!this.matchClosingParen()) {
            throw this.error;
        }
    }

    private Token skipWhitespace() {
        Token token;
        do {
            token = this.tokenizer.nextToken();
        } while (token.type == TokenType.WHITESPACE);
        return token;
    }
}

