/*
 * Decompiled with CFR 0.152.
 */
package se.fishtank.css.selectors.parser;

import java.util.LinkedList;
import java.util.List;
import se.fishtank.css.selectors.parser.NthParser;
import se.fishtank.css.selectors.parser.ParserException;
import se.fishtank.css.selectors.selector.AttributeSelector;
import se.fishtank.css.selectors.selector.Combinator;
import se.fishtank.css.selectors.selector.CompoundSelector;
import se.fishtank.css.selectors.selector.LocalNameSelector;
import se.fishtank.css.selectors.selector.PseudoClassSelector;
import se.fishtank.css.selectors.selector.PseudoElementSelector;
import se.fishtank.css.selectors.selector.PseudoFunctionSelector;
import se.fishtank.css.selectors.selector.PseudoNegationSelector;
import se.fishtank.css.selectors.selector.PseudoNthSelector;
import se.fishtank.css.selectors.selector.Selector;
import se.fishtank.css.selectors.selector.SimpleSelector;
import se.fishtank.css.selectors.tokenizer.Token;
import se.fishtank.css.selectors.tokenizer.TokenType;
import se.fishtank.css.selectors.tokenizer.Tokenizer;
import se.fishtank.css.selectors.util.Pair;

public class SelectorParser {
    private final Tokenizer tokenizer;
    private Token savedToken;

    private SelectorParser(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public static List<Selector> parse(String str) {
        return SelectorParser.parse(new Tokenizer(str));
    }

    public static List<Selector> parse(Tokenizer tokenizer) {
        return new SelectorParser(tokenizer).parseSelectorList();
    }

    private List<Selector> parseSelectorList() {
        LinkedList<Selector> selectors = new LinkedList<Selector>();
        selectors.add(this.parseSelector());
        while (true) {
            Token token = (Token)this.skipWhitespace().first;
            if (token.type == TokenType.EOF) break;
            if (token.type != TokenType.COMMA) {
                throw SelectorParser.expected(",", token);
            }
            selectors.add(this.parseSelector());
        }
        return selectors;
    }

    private Selector parseSelector() {
        Pair<List<SimpleSelector>, PseudoElementSelector> simpleSelectors = this.parseSimpleSelectors();
        CompoundSelector compoundSelector = CompoundSelector.of((List)simpleSelectors.first);
        PseudoElementSelector pseudoElement = (PseudoElementSelector)simpleSelectors.second;
        while (pseudoElement == null) {
            Pair<Token, Boolean> p = this.skipWhitespace();
            if (((Token)p.first).type == TokenType.EOF) break;
            if (((Token)p.first).type == TokenType.COMMA) {
                this.savedToken = (Token)p.first;
                break;
            }
            Combinator combinator = null;
            if (((Token)p.first).type == TokenType.DELIM) {
                switch (((Token)p.first).value) {
                    case ">": {
                        combinator = Combinator.CHILD;
                        break;
                    }
                    case "+": {
                        combinator = Combinator.NEXT_SIBLING;
                        break;
                    }
                    case "~": {
                        combinator = Combinator.LATER_SIBLING;
                    }
                }
            }
            if (combinator == null) {
                if (!((Boolean)p.second).booleanValue()) {
                    throw SelectorParser.expected("one of ' ', '>', '+', '~'", (Token)p.first);
                }
                combinator = Combinator.DESCENDANT;
                this.savedToken = (Token)p.first;
            }
            simpleSelectors = this.parseSimpleSelectors();
            compoundSelector = new CompoundSelector((List)simpleSelectors.first, new Pair<Combinator, CompoundSelector>(combinator, compoundSelector));
        }
        return new Selector(compoundSelector, pseudoElement);
    }

    private Pair<List<SimpleSelector>, PseudoElementSelector> parseSimpleSelectors() {
        SimpleSelector selector;
        int pos = this.tokenizer.getPosition();
        LinkedList<SimpleSelector> selectorSequence = new LinkedList<SimpleSelector>();
        PseudoElementSelector pseudoElement = null;
        boolean empty = true;
        Pair<String, Boolean> name = this.parseName();
        if (((Boolean)name.second).booleanValue() && !"*".equals(name.first)) {
            selectorSequence.add(new LocalNameSelector((String)name.first));
            empty = false;
        }
        while ((selector = this.parseOneSimpleSelector(false)) != null) {
            if (selector instanceof PseudoElementSelector) {
                empty = false;
                pseudoElement = (PseudoElementSelector)selector;
                break;
            }
            selectorSequence.add(selector);
            empty = false;
        }
        if (empty && !((Boolean)name.second).booleanValue()) {
            throw new IllegalArgumentException("No simple selectors found at position " + pos);
        }
        return new Pair(selectorSequence, pseudoElement);
    }

    private Pair<String, Boolean> parseName() {
        Token token = (Token)this.skipWhitespace().first;
        switch (token.type) {
            case DELIM: {
                if (!"*".equals(token.value)) break;
                return new Pair<String, Boolean>("*", true);
            }
            case IDENT: {
                return new Pair<String, Boolean>(token.value, true);
            }
        }
        this.savedToken = token;
        return new Pair<String, Boolean>("*", false);
    }

    private SimpleSelector parseOneSimpleSelector(boolean insideNegation) {
        Token token = this.nextToken();
        switch (token.type) {
            case HASH: {
                Token.Hash h = (Token.Hash)token;
                return new AttributeSelector(AttributeSelector.Match.EQUALS, "id", h.value);
            }
            case DELIM: {
                if (".".equals(token.value)) {
                    token = this.nextToken();
                    if (token.type == TokenType.IDENT) {
                        return new AttributeSelector(AttributeSelector.Match.INCLUDES, "class", token.value);
                    }
                    throw SelectorParser.expected("class value", token);
                }
                throw SelectorParser.expected(".", token);
            }
            case LEFT_SQUARE_BRACKET: {
                return this.parseAttribute();
            }
            case COLON: {
                token = this.nextToken();
                switch (token.type) {
                    case IDENT: {
                        switch (token.value.toLowerCase()) {
                            case "first-line": 
                            case "first-letter": 
                            case "before": 
                            case "after": {
                                return new PseudoElementSelector(token.value);
                            }
                        }
                        return new PseudoClassSelector(token.value);
                    }
                    case COLON: {
                        token = this.nextToken();
                        if (token.type != TokenType.IDENT) {
                            throw SelectorParser.expected("pseudo element value", token);
                        }
                        return new PseudoElementSelector(token.value);
                    }
                    case FUNCTION: {
                        return this.parseFunctionalPseudoClass(token.value, insideNegation);
                    }
                }
            }
        }
        this.savedToken = token;
        return null;
    }

    private AttributeSelector parseAttribute() {
        Token token = (Token)this.skipWhitespace().first;
        if (token.type != TokenType.IDENT) {
            throw SelectorParser.expected("attribute name", token);
        }
        String name = token.value;
        token = (Token)this.skipWhitespace().first;
        if (token.type == TokenType.RIGHT_SQUARE_BRACKET) {
            return new AttributeSelector(AttributeSelector.Match.EXISTS, name, "");
        }
        AttributeSelector.Match match = null;
        switch (token.type) {
            case PREFIX_MATCH: {
                match = AttributeSelector.Match.BEGINS;
                break;
            }
            case SUFFIX_MATCH: {
                match = AttributeSelector.Match.ENDS;
                break;
            }
            case SUBSTRING_MATCH: {
                match = AttributeSelector.Match.CONTAINS;
                break;
            }
            case INCLUDE_MATCH: {
                match = AttributeSelector.Match.INCLUDES;
                break;
            }
            case DASH_MATCH: {
                match = AttributeSelector.Match.HYPHENS;
                break;
            }
            case DELIM: {
                if ("=".equals(token.value)) {
                    match = AttributeSelector.Match.EQUALS;
                    break;
                }
                throw SelectorParser.expected("=", token);
            }
        }
        token = (Token)this.skipWhitespace().first;
        if (token.type != TokenType.IDENT && token.type != TokenType.STRING) {
            throw SelectorParser.expected("attribute value", token);
        }
        String value = token.value;
        token = (Token)this.skipWhitespace().first;
        if (token.type != TokenType.RIGHT_SQUARE_BRACKET) {
            throw SelectorParser.expected("]", token);
        }
        return new AttributeSelector(match, name, value);
    }

    private SimpleSelector parseFunctionalPseudoClass(String name, boolean insideNegation) {
        int pos = this.tokenizer.getPosition();
        switch (name.toLowerCase()) {
            case "nth-child": 
            case "nth-last-child": 
            case "nth-of-type": 
            case "nth-last-of-type": {
                Pair<Integer, Integer> nth = NthParser.parse(this.tokenizer);
                return new PseudoNthSelector(name, (Integer)nth.first, (Integer)nth.second);
            }
            case "not": {
                PseudoNegationSelector selector;
                if (insideNegation) {
                    throw new ParserException("Error at position " + pos + ": negations may not be nested");
                }
                Pair<String, Boolean> pair = this.parseName();
                if (((Boolean)pair.second).booleanValue()) {
                    selector = new PseudoNegationSelector(new LocalNameSelector((String)pair.first));
                } else {
                    SimpleSelector simpleSelector = this.parseOneSimpleSelector(true);
                    if (simpleSelector == null) {
                        throw SelectorParser.expected("simple selector", this.nextToken());
                    }
                    selector = new PseudoNegationSelector(simpleSelector);
                }
                Token token = (Token)this.skipWhitespace().first;
                if (token.type != TokenType.RIGHT_PAREN) {
                    throw SelectorParser.expected(")", token);
                }
                return selector;
            }
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            Token token = this.nextToken();
            if (token.type == TokenType.EOF) {
                throw new ParserException("EOF in function expression starting at position " + pos);
            }
            if (token.type == TokenType.RIGHT_PAREN) break;
            sb.append(token.value);
        }
        return new PseudoFunctionSelector(name, sb.toString());
    }

    private Token nextToken() {
        if (this.savedToken != null) {
            Token token = this.savedToken;
            this.savedToken = null;
            return token;
        }
        return this.tokenizer.nextToken();
    }

    private Pair<Token, Boolean> skipWhitespace() {
        boolean skipped = false;
        while (true) {
            Token token = this.nextToken();
            if (token.type != TokenType.WHITESPACE) {
                return new Pair<Token, Boolean>(token, skipped);
            }
            skipped = true;
        }
    }

    private static ParserException expected(String what, Token token) {
        String msg = String.format("Expected %s at position %d, got %s", new Object[]{what, token.position, token.type});
        return new ParserException(msg);
    }
}

