/*
 * Decompiled with CFR 0.152.
 */
package se.fishtank.css.selectors.tokenizer;

import se.fishtank.css.selectors.tokenizer.TokenType;

public class Token {
    public final TokenType type;
    public final int position;
    public final String value;

    public Token(TokenType type, int position, String value) {
        this.type = type;
        this.position = position;
        this.value = value;
    }

    public static class Dimension
    extends Number {
        public final String unit;

        public Dimension(int position, String value, boolean integer, String unit) {
            super(TokenType.DIMENSION, position, value, integer);
            this.unit = unit;
        }
    }

    public static class Number
    extends Token {
        public final boolean integer;

        protected Number(TokenType type, int position, String value, boolean integer) {
            super(type, position, value);
            this.integer = integer;
        }

        public static Number number(int position, String value, boolean integer) {
            return new Number(TokenType.NUMBER, position, value, integer);
        }

        public static Number percentage(int position, String value, boolean integer) {
            return new Number(TokenType.PERCENTAGE, position, value, integer);
        }
    }

    public static class Hash
    extends Token {
        public final boolean id;

        public Hash(int position, String value, boolean id) {
            super(TokenType.HASH, position, value);
            this.id = id;
        }
    }

    public static class UnicodeRange
    extends Token {
        public final int start;
        public final int end;

        public UnicodeRange(int position, int start, int end) {
            super(TokenType.UNICODE_RANGE, position, String.format("U+%04X-U+%04X", start, end));
            this.start = start;
            this.end = end;
        }
    }
}

