/*
 * Decompiled with CFR 0.152.
 */
package se.fishtank.css.selectors.tokenizer;

import java.util.regex.Pattern;
import se.fishtank.css.selectors.tokenizer.Token;
import se.fishtank.css.selectors.tokenizer.TokenType;

public class Tokenizer {
    public static final char REPLACEMENT_CHAR = '\ufffd';
    public static final int EOF = -1;
    public static final Token EOF_TOKEN = new Token(TokenType.EOF, -1, "");
    public static final Pattern PREPROCESS_REGEX = Pattern.compile("\\f|\\r\\n?");
    public final String input;
    private int pos = 0;
    private int mark = 0;

    public Tokenizer(String input) {
        this.input = PREPROCESS_REGEX.matcher(input).replaceAll("\n").replace('\u0000', '\ufffd');
    }

    public int getPosition() {
        return this.pos;
    }

    public void reset() {
        this.pos = 0;
        this.mark = 0;
    }

    public static boolean isAlpha(int c) {
        return (c | 0x20) >= 97 && (c | 0x20) <= 122;
    }

    public static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    public static boolean isHexDigit(int c) {
        return Tokenizer.isDigit(c) || (c | 0x20) >= 97 && (c | 0x20) <= 102;
    }

    public static boolean isSpace(int c) {
        return c == 32 || c == 9 || c == 13 || c == 10 || c == 12;
    }

    public static boolean isNameStart(int c) {
        return c == 95 || c >= 128 || Tokenizer.isAlpha(c);
    }

    public static boolean isName(int c) {
        return c == 45 || Tokenizer.isNameStart(c) || Tokenizer.isDigit(c);
    }

    public static boolean isNonPrintable(int c) {
        return c >= 0 && c <= 8 || c == 11 || c >= 14 && c <= 31 || c == 127;
    }

    public static boolean isValidEscape(int c1, int c2) {
        return c1 == 92 && c2 != 10;
    }

    public static int hexValue(int c) {
        if (c < 65) {
            return c - 48;
        }
        return c - 65 + 10 & 0xF;
    }

    public boolean isEof() {
        return this.pos >= this.input.length();
    }

    public Token nextToken() {
        if (this.isEof()) {
            return EOF_TOKEN;
        }
        this.skipComments();
        if (this.isEof()) {
            return EOF_TOKEN;
        }
        int p = this.pos;
        int n = this.skipSpace();
        if (n > 0) {
            return new Token(TokenType.WHITESPACE, p, "");
        }
        this.mark();
        int c = this.next();
        switch (c) {
            case 34: {
                this.setPositionToMark();
                return this.consumeStringToken(false);
            }
            case 35: {
                if (this.isIdentStart()) {
                    return new Token.Hash(p, this.consumeName(), true);
                }
                int[] d = this.peek2();
                if (Tokenizer.isName(d[0]) || Tokenizer.isValidEscape(d[0], d[1])) {
                    return new Token.Hash(p, this.consumeName(), false);
                }
                return new Token(TokenType.DELIM, p, "#");
            }
            case 36: {
                if (this.peek() == 61) {
                    this.next();
                    return new Token(TokenType.SUFFIX_MATCH, p, "$=");
                }
                return new Token(TokenType.DELIM, p, "$");
            }
            case 39: {
                this.setPositionToMark();
                return this.consumeStringToken(true);
            }
            case 40: {
                return new Token(TokenType.LEFT_PAREN, p, "(");
            }
            case 41: {
                return new Token(TokenType.RIGHT_PAREN, p, ")");
            }
            case 42: {
                if (this.peek() == 61) {
                    this.next();
                    return new Token(TokenType.SUBSTRING_MATCH, p, "*=");
                }
                return new Token(TokenType.DELIM, p, "*");
            }
            case 43: {
                this.setPositionToMark();
                if (this.isNumberStart()) {
                    return this.consumeNumericToken();
                }
                this.next();
                return new Token(TokenType.DELIM, p, "+");
            }
            case 44: {
                return new Token(TokenType.COMMA, p, ",");
            }
            case 45: {
                this.setPositionToMark();
                if (this.isNumberStart()) {
                    return this.consumeNumericToken();
                }
                if (this.isIdentStart()) {
                    return this.consumeIdentLikeToken();
                }
                if (this.consume("-->")) {
                    return new Token(TokenType.CDC, p, "-->");
                }
                this.next();
                return new Token(TokenType.DELIM, p, "-");
            }
            case 46: {
                this.setPositionToMark();
                if (this.isNumberStart()) {
                    return this.consumeNumericToken();
                }
                this.next();
                return new Token(TokenType.DELIM, p, ".");
            }
            case 58: {
                return new Token(TokenType.COLON, p, ":");
            }
            case 59: {
                return new Token(TokenType.SEMICOLON, p, ";");
            }
            case 60: {
                if (this.consume("!--")) {
                    return new Token(TokenType.CDO, p, "<!--");
                }
                return new Token(TokenType.DELIM, p, "<");
            }
            case 64: {
                if (this.isIdentStart()) {
                    return new Token(TokenType.AT_KEYWORD, p, this.consumeName());
                }
                return new Token(TokenType.DELIM, p, "@");
            }
            case 91: {
                return new Token(TokenType.LEFT_SQUARE_BRACKET, p, "[");
            }
            case 93: {
                return new Token(TokenType.RIGHT_SQUARE_BRACKET, p, "]");
            }
            case 92: {
                if (Tokenizer.isValidEscape(92, this.peek())) {
                    this.setPositionToMark();
                    return this.consumeIdentLikeToken();
                }
                return new Token(TokenType.DELIM, p, "\\");
            }
            case 94: {
                if (this.peek() == 61) {
                    this.next();
                    return new Token(TokenType.PREFIX_MATCH, p, "^=");
                }
                return new Token(TokenType.DELIM, p, "^");
            }
            case 123: {
                return new Token(TokenType.LEFT_CURLY_BRACKET, p, "{");
            }
            case 125: {
                return new Token(TokenType.RIGHT_CURLY_BRACKET, p, "}");
            }
            case 124: {
                int x = this.peek();
                switch (x) {
                    case 61: {
                        this.next();
                        return new Token(TokenType.DASH_MATCH, p, "|=");
                    }
                    case 124: {
                        this.next();
                        return new Token(TokenType.COLUMN, p, "||");
                    }
                }
                return new Token(TokenType.DELIM, p, "|");
            }
            case 126: {
                if (this.peek() == 61) {
                    this.next();
                    return new Token(TokenType.INCLUDE_MATCH, p, "~=");
                }
                return new Token(TokenType.DELIM, p, "~");
            }
        }
        if (Tokenizer.isDigit(c)) {
            this.setPositionToMark();
            return this.consumeNumericToken();
        }
        if (c == 85 || c == 117) {
            int[] e = this.peek2();
            if (e[0] == 43 && (e[1] == 63 || Tokenizer.isHexDigit(e[1]))) {
                this.next();
                return this.consumeUnicodeRangeToken();
            }
            this.setPositionToMark();
            return this.consumeIdentLikeToken();
        }
        if (Tokenizer.isNameStart(c)) {
            this.setPositionToMark();
            return this.consumeIdentLikeToken();
        }
        return new Token(TokenType.DELIM, p, String.copyValueOf(Character.toChars(c)));
    }

    private void mark() {
        this.mark = this.pos;
    }

    private void setPositionToMark() {
        this.pos = this.mark;
    }

    private int next() {
        if (this.isEof()) {
            return -1;
        }
        int c = this.input.codePointAt(this.pos);
        this.pos += Character.charCount(c);
        return c;
    }

    private int peek() {
        int p = this.pos;
        int c = this.next();
        this.pos = p;
        return c;
    }

    private int[] peek2() {
        int p = this.pos;
        int[] c = new int[]{this.next(), this.next()};
        this.pos = p;
        return c;
    }

    private int[] peek3() {
        int p = this.pos;
        int[] c = new int[]{this.next(), this.next(), this.next()};
        this.pos = p;
        return c;
    }

    private void skipComments() {
        if (this.consume("/*")) {
            int c;
            do {
                if ((c = this.next()) != -1) continue;
                return;
            } while (c != 42 || this.peek() != 47);
            this.next();
            return;
        }
    }

    private int skipSpace() {
        int n = 0;
        while (Tokenizer.isSpace(this.peek())) {
            ++n;
            this.next();
        }
        return n;
    }

    private boolean consume(String str) {
        if (!this.isEof() && this.input.startsWith(str, this.pos)) {
            this.pos += str.length();
            return true;
        }
        return false;
    }

    private boolean isIdentStart() {
        if (this.isEof()) {
            return false;
        }
        int[] c = this.peek3();
        return Tokenizer.isNameStart(c[0]) || Tokenizer.isValidEscape(c[0], c[1]) || c[0] == 45 && (Tokenizer.isNameStart(c[1]) || Tokenizer.isValidEscape(c[1], c[2]));
    }

    private boolean isNumberStart() {
        if (this.isEof()) {
            return false;
        }
        int[] c = this.peek3();
        if (Tokenizer.isDigit(c[0]) || c[0] == 46 && Tokenizer.isDigit(c[1])) {
            return true;
        }
        if (c[0] == 43 || c[0] == 45) {
            if (Tokenizer.isDigit(c[1])) {
                return true;
            }
            if (c[1] == 46 && Tokenizer.isDigit(c[2])) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidExponent() {
        if (this.isEof()) {
            return false;
        }
        try {
            this.mark();
            int c = this.next();
            if (c != 101 && c != 69) {
                boolean bl = false;
                return bl;
            }
            c = this.next();
            if (c == 43 || c == 45) {
                boolean bl = Tokenizer.isDigit(this.next());
                return bl;
            }
            boolean bl = Tokenizer.isDigit(c);
            return bl;
        }
        finally {
            this.setPositionToMark();
        }
    }

    private int consumeEscape() {
        if (this.isEof()) {
            return 65533;
        }
        if (Tokenizer.isHexDigit(this.peek())) {
            int uc = 0;
            for (int len = 6; len > 0 && Tokenizer.isHexDigit(this.peek()); --len) {
                uc = (uc << 4) + Tokenizer.hexValue(this.next());
            }
            if (uc == 0 || uc > 0x10FFFF || uc >= 55296 && uc <= 57343) {
                uc = 65533;
            }
            if (Tokenizer.isSpace(this.peek())) {
                this.next();
            }
            return uc;
        }
        return this.next();
    }

    private String consumeName() {
        StringBuilder sb = new StringBuilder();
        while (true) {
            this.mark();
            int c = this.next();
            if (Tokenizer.isName(c)) {
                sb.appendCodePoint(c);
                continue;
            }
            if (!Tokenizer.isValidEscape(c, this.peek())) break;
            sb.appendCodePoint(this.consumeEscape());
        }
        this.setPositionToMark();
        return sb.toString();
    }

    private Token.Number consumeNumber() {
        StringBuilder sb = new StringBuilder();
        int p = this.pos;
        int c = this.peek();
        if (c == 43 || c == 45) {
            sb.appendCodePoint(this.next());
        }
        while (Tokenizer.isDigit(this.peek())) {
            sb.appendCodePoint(this.next());
        }
        this.mark();
        boolean integer = true;
        int c1 = this.next();
        int c2 = this.next();
        if (c1 == 46 && Tokenizer.isDigit(c2)) {
            sb.appendCodePoint(c1).appendCodePoint(c2);
            while (Tokenizer.isDigit(this.peek())) {
                sb.appendCodePoint(this.next());
            }
            integer = false;
        } else {
            this.setPositionToMark();
        }
        if (this.isValidExponent()) {
            integer = false;
            sb.appendCodePoint(this.next()).appendCodePoint(this.next());
            while (Tokenizer.isDigit(this.peek())) {
                sb.appendCodePoint(this.next());
            }
        }
        return Token.Number.number(p, sb.toString(), integer);
    }

    private Token consumeNumericToken() {
        Token.Number token = this.consumeNumber();
        if (this.peek() == 37) {
            this.next();
            return Token.Number.percentage(token.position, token.value, token.integer);
        }
        if (this.isIdentStart()) {
            return new Token.Dimension(token.position, token.value, token.integer, this.consumeName());
        }
        return token;
    }

    private Token consumeIdentLikeToken() {
        int p = this.pos;
        String name = this.consumeName();
        TokenType type = TokenType.IDENT;
        if (this.peek() == 40) {
            this.next();
            if ("url".equalsIgnoreCase(name)) {
                return this.consumeUrlToken();
            }
            type = TokenType.FUNCTION;
        }
        return new Token(type, p, name);
    }

    private Token consumeStringToken(boolean apostrophe) {
        StringBuilder sb = new StringBuilder();
        int p = this.pos;
        this.next();
        while (true) {
            this.mark();
            int c = this.next();
            if (c == -1 || c == 39 && apostrophe || c == 34 && !apostrophe) break;
            if (c == 10) {
                this.setPositionToMark();
                return new Token(TokenType.BAD_STRING, p, "");
            }
            if (c == 92) {
                int d = this.peek();
                if (d == -1) continue;
                if (d == 10) {
                    this.next();
                    continue;
                }
                sb.appendCodePoint(this.consumeEscape());
                continue;
            }
            sb.appendCodePoint(c);
        }
        return new Token(TokenType.STRING, p, sb.toString());
    }

    private Token consumeUrlToken() {
        this.skipSpace();
        int p = this.pos;
        if (this.isEof()) {
            return new Token(TokenType.URL, p, "");
        }
        int c = this.peek();
        if (c == 39 || c == 34) {
            Token token = this.consumeStringToken(c != 34);
            if (token.type == TokenType.BAD_STRING) {
                p = this.pos;
                this.consumeBadUrl();
                return new Token(TokenType.BAD_URL, p, token.value);
            }
            this.skipSpace();
            c = this.peek();
            if (c == 41 || c == -1) {
                if (c == 41) {
                    this.next();
                }
                return new Token(TokenType.URL, p, token.value);
            }
            p = this.pos;
            this.consumeBadUrl();
            return new Token(TokenType.BAD_URL, p, token.value);
        }
        StringBuilder sb = new StringBuilder();
        boolean spaceSeen = false;
        while ((c = this.next()) != 41 && c != -1) {
            if (Tokenizer.isSpace(c)) {
                spaceSeen = true;
                this.skipSpace();
                continue;
            }
            if (spaceSeen) {
                p = this.pos;
                this.consumeBadUrl();
                return new Token(TokenType.BAD_URL, p, "");
            }
            if (c == 39 || c == 34 || c == 40 || Tokenizer.isNonPrintable(c)) {
                p = this.pos;
                this.consumeBadUrl();
                return new Token(TokenType.BAD_URL, p, "");
            }
            if (c == 92) {
                if (Tokenizer.isValidEscape(c, this.peek())) {
                    sb.appendCodePoint(this.consumeEscape());
                    continue;
                }
                p = this.pos;
                this.consumeBadUrl();
                return new Token(TokenType.BAD_URL, p, "");
            }
            sb.appendCodePoint(c);
        }
        return new Token(TokenType.URL, p, sb.toString());
    }

    private Token.UnicodeRange consumeUnicodeRangeToken() {
        int length;
        int p = this.pos;
        int start = 0;
        for (length = 0; Tokenizer.isHexDigit(this.peek()) && length < 6; ++length) {
            start = (start << 4) + Tokenizer.hexValue(this.next());
        }
        int q = 0;
        if (length < 6) {
            while (this.peek() == 63 && length < 6) {
                this.next();
                ++length;
                ++q;
            }
        }
        if (q != 0) {
            int end = start;
            for (int i = 0; i < q; ++i) {
                start <<= 4;
                end = (end << 4) + 15;
            }
            return new Token.UnicodeRange(p, start, end);
        }
        int end = 0;
        int[] c = this.peek2();
        if (c[0] == 45 && Tokenizer.isHexDigit(c[1])) {
            this.next();
            for (length = 0; Tokenizer.isHexDigit(this.peek()) && length < 6; ++length) {
                end = (end << 4) + Tokenizer.hexValue(this.next());
            }
        } else {
            end = start;
        }
        return new Token.UnicodeRange(p, start, end);
    }

    private void consumeBadUrl() {
        int c;
        while ((c = this.next()) != 41 && c != -1) {
            if (!Tokenizer.isValidEscape(c, this.peek())) continue;
            this.consumeEscape();
        }
    }
}

