/*
 * Decompiled with CFR 0.152.
 */
package se.kb.oai.ore.impl;

import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;
import se.kb.oai.OAIException;
import se.kb.oai.ore.AggregateBase;
import se.kb.oai.ore.AggregatedResource;
import se.kb.oai.ore.Metadata;
import se.kb.oai.ore.ResourceMap;
import se.kb.oai.ore.Type;
import se.kb.oai.ore.impl.AtomConstants;
import se.kb.oai.ore.impl.FactoryBase;
import se.kb.xml.XPathWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomFactory
extends FactoryBase {
    @Override
    public ResourceMap getResourceMap(Element feed) throws OAIException {
        try {
            String created;
            XPathWrapper xpath = this.createXPath((Node)feed);
            ResourceMap map = new ResourceMap(xpath.valueOf(AtomConstants.ID_XPATH));
            map.setCreator(xpath.valueOf(AtomConstants.CREATOR_XPATH));
            map.setModified(AtomConstants.DATE_FORMAT.parse(xpath.valueOf(AtomConstants.MODIFIED_XPATH)));
            String rights = xpath.valueOf(AtomConstants.RIGHTS_XPATH);
            if (this.notEmpty(rights)) {
                map.setRights(rights);
            }
            if (this.notEmpty(created = xpath.valueOf(AtomConstants.CREATED_XPATH))) {
                map.setCreated(AtomConstants.DATE_FORMAT.parse(created));
            }
            this.addTypesAndMetadata(map.getAggregation(), xpath.selectNodes("*"));
            for (Node node : xpath.selectNodes(AtomConstants.ENTRY_XPATH)) {
                xpath = this.createXPath(node);
                AggregatedResource resource = new AggregatedResource(xpath.valueOf(AtomConstants.ENTRY_ID_XPATH));
                this.addTypesAndMetadata(resource, xpath.selectNodes("*"));
                map.getAggregation().addResource(resource);
            }
            return map;
        }
        catch (Exception e) {
            throw new OAIException(e);
        }
    }

    private void addTypesAndMetadata(AggregateBase aggregate, List<Node> nodes) {
        for (Node node : nodes) {
            Element element = (Element)node;
            if (element.getNamespace().equals((Object)AtomConstants.DC_NS)) {
                aggregate.addMetadata(new Metadata(Metadata.Namespace.DC, element.getName(), element.getText()));
                continue;
            }
            if (element.getNamespace().equals((Object)AtomConstants.DCTERMS_NS)) {
                aggregate.addMetadata(new Metadata(Metadata.Namespace.DCTERMS, element.getName(), element.getText()));
                continue;
            }
            if (!element.getNamespace().equals((Object)AtomConstants.RDF_NS) || !element.getName().equals("type")) continue;
            aggregate.addType(new Type(element.getText()));
        }
    }

    private XPathWrapper createXPath(Node node) {
        XPathWrapper xpath = new XPathWrapper(node);
        xpath.addNamespace("atom", "http://www.w3.org/2005/Atom");
        xpath.addNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        xpath.addNamespace("dc", "http://purl.org/dc/");
        xpath.addNamespace("dcterms", "http://purl.org/dc/terms/");
        return xpath;
    }

    private boolean notEmpty(String string) {
        return string != null && string.trim().length() > 0;
    }
}

