/*
 * Decompiled with CFR 0.152.
 */
package se.kb.oai.ore.impl;

import java.util.List;
import java.util.UUID;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import se.kb.oai.ore.AggregatedResource;
import se.kb.oai.ore.Metadata;
import se.kb.oai.ore.ResourceMap;
import se.kb.oai.ore.Type;
import se.kb.oai.ore.impl.AtomConstants;
import se.kb.oai.ore.impl.SerializerBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomSerializer
extends SerializerBase {
    @Override
    public Element serializeToXml(ResourceMap map) {
        Element feed = DocumentHelper.createElement((QName)AtomConstants.FEED);
        feed.addNamespace("atom", "http://www.w3.org/2005/Atom");
        feed.addNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        feed.addNamespace("dc", "http://purl.org/dc/");
        feed.addNamespace("dcterms", "http://purl.org/dc/terms/");
        Element id = DocumentHelper.createElement((QName)AtomConstants.ID);
        id.setText(this.createAtomId());
        feed.add(id);
        Element link = DocumentHelper.createElement((QName)AtomConstants.LINK);
        link.addAttribute("rel", "self");
        link.addAttribute("type", "application/atom+xml");
        link.addAttribute("href", map.getId().toString());
        feed.add(link);
        Element title = DocumentHelper.createElement((QName)AtomConstants.TITLE);
        title.setText("Resource Map " + map.getId().toString());
        feed.add(title);
        Element author = DocumentHelper.createElement((QName)AtomConstants.AUTHOR);
        Element name = DocumentHelper.createElement((QName)AtomConstants.NAME);
        name.setText(map.getCreator());
        author.add(name);
        feed.add(author);
        if (map.getRights() != null) {
            Element rights = DocumentHelper.createElement((QName)AtomConstants.RIGHTS);
            rights.setText(map.getRights());
            feed.add(rights);
        }
        if (map.getCreated() != null) {
            Element published = DocumentHelper.createElement((QName)AtomConstants.PUBLISHED);
            published.setText(AtomConstants.DATE_FORMAT.format(map.getCreated()));
            feed.add(published);
        }
        Element updated = DocumentHelper.createElement((QName)AtomConstants.UPDATED);
        updated.setText(AtomConstants.DATE_FORMAT.format(map.getModified()));
        feed.add(updated);
        Element category = DocumentHelper.createElement((QName)AtomConstants.CATEGORY);
        category.addAttribute("scheme", "http://www.openarchives.org/ore/terms/");
        category.addAttribute("term", "http://www.openarchives.org/ore/terms/ResourceMap");
        category.addAttribute("label", "Resource Map");
        feed.add(category);
        Element icon = DocumentHelper.createElement((QName)AtomConstants.ICON);
        icon.setText("http://www.openarchives.org/ore/logos/ore_icon.png");
        feed.add(icon);
        link = DocumentHelper.createElement((QName)AtomConstants.LINK);
        link.addAttribute("rel", "describes");
        link.addAttribute("href", map.getAggregation().getId().toString());
        feed.add(link);
        this.addTypes(feed, map.getAggregation().getTypes());
        this.addMetadata(feed, map.getAggregation().getMetadata());
        for (AggregatedResource resource : map.getAggregation().getResources()) {
            Element entry = DocumentHelper.createElement((QName)AtomConstants.ENTRY);
            id = DocumentHelper.createElement((QName)AtomConstants.ID);
            id.setText(this.createAtomId());
            entry.add(id);
            title = DocumentHelper.createElement((QName)AtomConstants.TITLE);
            title.setText("Aggregated Resource " + resource.getId().toString());
            entry.add(title);
            updated = DocumentHelper.createElement((QName)AtomConstants.UPDATED);
            updated.setText(AtomConstants.DATE_FORMAT.format(map.getModified()));
            entry.add(updated);
            link = DocumentHelper.createElement((QName)AtomConstants.LINK);
            link.addAttribute("rel", "alternate");
            if (resource.getMimeType() != null) {
                link.addAttribute("type", resource.getMimeType());
            }
            link.addAttribute("href", resource.getId().toString());
            entry.add(link);
            this.addTypes(entry, resource.getTypes());
            this.addMetadata(entry, resource.getMetadata());
            feed.add(entry);
        }
        return feed;
    }

    private void addTypes(Element target, List<Type> list) {
        for (Type type : list) {
            Element element = DocumentHelper.createElement((QName)AtomConstants.TYPE);
            element.setText(type.getValue());
            target.add(element);
        }
    }

    private void addMetadata(Element target, List<Metadata> list) {
        for (Metadata metadata : list) {
            Element element = DocumentHelper.createElement((QName)metadata.getName());
            element.setText(metadata.getValue());
            target.add(element);
        }
    }

    protected String createAtomId() {
        return "urn:uuid:" + UUID.randomUUID().toString();
    }
}

