/*
 * Decompiled with CFR 0.152.
 */
package se.kb.oai.pmh;

import java.net.URL;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import se.kb.oai.OAIException;
import se.kb.oai.pmh.ErrorResponseException;
import se.kb.oai.pmh.Identification;
import se.kb.oai.pmh.IdentifiersList;
import se.kb.oai.pmh.MetadataFormatsList;
import se.kb.oai.pmh.QueryBuilder;
import se.kb.oai.pmh.Record;
import se.kb.oai.pmh.RecordsList;
import se.kb.oai.pmh.ResumptionToken;
import se.kb.oai.pmh.SetsList;

public class OaiPmhServer {
    private QueryBuilder builder;
    private SAXReader reader;

    public OaiPmhServer(String url) {
        this.builder = new QueryBuilder(url);
        this.reader = new SAXReader();
    }

    public OaiPmhServer(URL url) {
        this(url.toString());
    }

    public String getBaseUrl() {
        return this.builder.getBaseUrl();
    }

    public Record getRecord(String identifier, String metadataPrefix) throws OAIException {
        try {
            String query = this.builder.buildGetRecordQuery(identifier, metadataPrefix);
            Document document = this.reader.read(query);
            return new Record(document);
        }
        catch (ErrorResponseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OAIException(e);
        }
    }

    public Identification identify() throws OAIException {
        try {
            String query = this.builder.buildIdentifyQuery();
            Document document = this.reader.read(query);
            return new Identification(document);
        }
        catch (ErrorResponseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OAIException(e);
        }
    }

    public IdentifiersList listIdentifiers(String metadataPrefix) throws OAIException {
        return this.listIdentifiers(metadataPrefix, null, null, null);
    }

    public IdentifiersList listIdentifiers(String metadataPrefix, String from, String until, String set) throws OAIException {
        try {
            String query = this.builder.buildListIdentifiersQuery(metadataPrefix, from, until, set);
            Document document = this.reader.read(query);
            return new IdentifiersList(document);
        }
        catch (ErrorResponseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OAIException(e);
        }
    }

    public IdentifiersList listIdentifiers(ResumptionToken resumptionToken) throws OAIException {
        try {
            String query = this.builder.buildListIdentifiersQuery(resumptionToken);
            Document document = this.reader.read(query);
            return new IdentifiersList(document);
        }
        catch (ErrorResponseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OAIException(e);
        }
    }

    public RecordsList listRecords(String metadataPrefix) throws OAIException {
        return this.listRecords(metadataPrefix, null, null, null);
    }

    public RecordsList listRecords(String metadataPrefix, String from, String until, String set) throws OAIException {
        try {
            String query = this.builder.buildListRecordsQuery(metadataPrefix, from, until, set);
            Document document = this.reader.read(query);
            return new RecordsList(document);
        }
        catch (ErrorResponseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OAIException(e);
        }
    }

    public RecordsList listRecords(ResumptionToken resumptionToken) throws OAIException {
        try {
            String query = this.builder.buildListRecordsQuery(resumptionToken);
            Document document = this.reader.read(query);
            return new RecordsList(document);
        }
        catch (ErrorResponseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OAIException(e);
        }
    }

    public MetadataFormatsList listMetadataFormats() throws OAIException {
        return this.listMetadataFormats(null);
    }

    public MetadataFormatsList listMetadataFormats(String identifier) throws OAIException {
        try {
            String query = this.builder.buildListMetadataFormatsQuery(identifier);
            Document document = this.reader.read(query);
            return new MetadataFormatsList(document);
        }
        catch (ErrorResponseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OAIException(e);
        }
    }

    public SetsList listSets() throws OAIException {
        try {
            String query = this.builder.buildListSetsQuery();
            Document document = this.reader.read(query);
            return new SetsList(document);
        }
        catch (ErrorResponseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OAIException(e);
        }
    }

    public SetsList listSets(ResumptionToken resumptionToken) throws OAIException {
        try {
            String query = this.builder.buildListSetsQuery(resumptionToken);
            Document document = this.reader.read(query);
            return new SetsList(document);
        }
        catch (ErrorResponseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OAIException(e);
        }
    }
}

