/*
 * Decompiled with CFR 0.152.
 */
package se.kb.oai.pmh;

import se.kb.oai.pmh.ResumptionToken;

public class QueryBuilder {
    private static final String VERB = "verb";
    private static final String QUESTION_MARK = "?";
    private static final String AMPERSAND = "&";
    private static final String EQUAL_SIGN = "=";
    private static final String IDENTIFIER = "identifier";
    private static final String METADATA_PREFIX = "metadataPrefix";
    private static final String FROM = "from";
    private static final String UNTIL = "until";
    private static final String SET = "set";
    private static final String RESUMPTION_TOKEN = "resumptionToken";
    private String basesurl;
    private String extendedBasesurl;

    public QueryBuilder(String baseurl) {
        this.basesurl = baseurl;
        this.extendedBasesurl = baseurl + QUESTION_MARK + VERB + EQUAL_SIGN;
    }

    public String getBaseUrl() {
        return this.basesurl;
    }

    public String buildGetRecordQuery(String identifier, String metadataPrefix) {
        StringBuffer buffer = new StringBuffer(this.extendedBasesurl);
        buffer.append((Object)Verb.GetRecord);
        buffer.append(AMPERSAND).append(IDENTIFIER).append(EQUAL_SIGN).append(identifier);
        buffer.append(AMPERSAND).append(METADATA_PREFIX).append(EQUAL_SIGN).append(metadataPrefix);
        return buffer.toString();
    }

    public String buildIdentifyQuery() {
        StringBuffer buffer = new StringBuffer(this.extendedBasesurl);
        buffer.append((Object)Verb.Identify);
        return buffer.toString();
    }

    public String buildListIdentifiersQuery(String metadataPrefix, String from, String until, String set) {
        StringBuffer buffer = new StringBuffer(this.extendedBasesurl);
        buffer.append((Object)Verb.ListIdentifiers);
        buffer.append(AMPERSAND).append(METADATA_PREFIX).append(EQUAL_SIGN).append(metadataPrefix);
        if (from != null) {
            buffer.append(AMPERSAND).append(FROM).append(EQUAL_SIGN).append(from);
        }
        if (until != null) {
            buffer.append(AMPERSAND).append(UNTIL).append(EQUAL_SIGN).append(until);
        }
        if (set != null) {
            buffer.append(AMPERSAND).append(SET).append(EQUAL_SIGN).append(set);
        }
        return buffer.toString();
    }

    public String buildListIdentifiersQuery(ResumptionToken token) {
        StringBuffer buffer = new StringBuffer(this.extendedBasesurl);
        buffer.append((Object)Verb.ListIdentifiers);
        buffer.append(AMPERSAND).append(RESUMPTION_TOKEN).append(EQUAL_SIGN).append(token.getId());
        return buffer.toString();
    }

    public String buildListMetadataFormatsQuery(String identifier) {
        StringBuffer buffer = new StringBuffer(this.extendedBasesurl);
        buffer.append((Object)Verb.ListMetadataFormats);
        if (identifier != null) {
            buffer.append(AMPERSAND).append(IDENTIFIER).append(EQUAL_SIGN).append(identifier);
        }
        return buffer.toString();
    }

    public String buildListRecordsQuery(String metadataPrefix, String from, String until, String set) {
        StringBuffer buffer = new StringBuffer(this.extendedBasesurl);
        buffer.append((Object)Verb.ListRecords);
        buffer.append(AMPERSAND).append(METADATA_PREFIX).append(EQUAL_SIGN).append(metadataPrefix);
        if (from != null) {
            buffer.append(AMPERSAND).append(FROM).append(EQUAL_SIGN).append(from);
        }
        if (until != null) {
            buffer.append(AMPERSAND).append(UNTIL).append(EQUAL_SIGN).append(until);
        }
        if (set != null) {
            buffer.append(AMPERSAND).append(SET).append(EQUAL_SIGN).append(set);
        }
        return buffer.toString();
    }

    public String buildListRecordsQuery(ResumptionToken token) {
        StringBuffer buffer = new StringBuffer(this.extendedBasesurl);
        buffer.append((Object)Verb.ListRecords);
        buffer.append(AMPERSAND).append(RESUMPTION_TOKEN).append(EQUAL_SIGN).append(token.getId());
        return buffer.toString();
    }

    public String buildListSetsQuery() {
        StringBuffer buffer = new StringBuffer(this.extendedBasesurl);
        buffer.append((Object)Verb.ListSets);
        return buffer.toString();
    }

    public String buildListSetsQuery(ResumptionToken token) {
        StringBuffer buffer = new StringBuffer(this.extendedBasesurl);
        buffer.append((Object)Verb.ListSets);
        buffer.append(AMPERSAND).append(RESUMPTION_TOKEN).append(EQUAL_SIGN).append(token.getId());
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Verb {
        Identify,
        GetRecord,
        ListIdentifiers,
        ListMetadataFormats,
        ListRecords,
        ListSets;

    }
}

