/*
 * Decompiled with CFR 0.152.
 */
package se.kb.oai.pmh;

import java.io.IOException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import se.kb.oai.pmh.ErrorResponseException;
import se.kb.oai.pmh.Header;
import se.kb.oai.pmh.ResponseBase;
import se.kb.xml.XMLUtils;
import se.kb.xml.XPathWrapper;

public class Record
extends ResponseBase {
    private static final String RECORD_XPATH = "oai:GetRecord/oai:record";
    private static final String HEADER_XPATH = "oai:header";
    private static final String METADATA_XPATH = "oai:metadata/*";
    private static final String ABOUT_XPATH = "oai:about/*";
    private Header header;
    private Element metadata;
    private Element about;

    public Record(Document document) throws ErrorResponseException {
        this(document, null);
    }

    public Record(Document document, Node record) throws ErrorResponseException {
        super(document);
        this.xpath = record == null ? new XPathWrapper(this.xpath.selectSingleNode(RECORD_XPATH)) : new XPathWrapper(record);
        this.xpath.addNamespace("oai", "http://www.openarchives.org/OAI/2.0/");
        Node headerNode = this.xpath.selectSingleNode(HEADER_XPATH);
        this.header = new Header(headerNode);
        this.metadata = this.xpath.selectSingleElement(METADATA_XPATH);
        this.about = this.xpath.selectSingleElement(ABOUT_XPATH);
    }

    public Header getHeader() {
        return this.header;
    }

    public Element getMetadata() {
        return this.metadata;
    }

    public String getMetadataAsString() throws IOException {
        return XMLUtils.xmlToString(this.getMetadata());
    }

    public Element getAbout() {
        return this.about;
    }
}

