/*
 * Decompiled with CFR 0.152.
 */
package se.kb.oai.pmh;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import se.kb.oai.pmh.ErrorResponseException;
import se.kb.oai.pmh.ResumptionToken;
import se.kb.xml.XPathWrapper;

public abstract class ResponseBase {
    public static final String OAI_NS_PREFIX = "oai";
    public static final String OAI_NS_URI = "http://www.openarchives.org/OAI/2.0/";
    private static final String RESPONSE_DATE_XPATH = "oai:responseDate";
    private static final String RESUMPTION_TOKEN_XPATH = "*/oai:resumptionToken";
    private static final String ERROR_XPATH = "oai:error";
    protected Document response;
    protected XPathWrapper xpath;
    protected String responseDate;
    protected ResumptionToken resumptionToken;

    public ResponseBase(Document document) throws ErrorResponseException {
        Element root = document.getRootElement();
        this.xpath = new XPathWrapper((Node)root);
        this.xpath.addNamespace(OAI_NS_PREFIX, OAI_NS_URI);
        this.response = document;
        this.responseDate = this.xpath.valueOf(RESPONSE_DATE_XPATH);
        Element token = this.xpath.selectSingleElement(RESUMPTION_TOKEN_XPATH);
        this.resumptionToken = token != null ? new ResumptionToken(token) : null;
        Element error = this.xpath.selectSingleElement(ERROR_XPATH);
        if (error != null) {
            throw new ErrorResponseException(error);
        }
    }

    public Document getResponse() {
        return this.response;
    }

    public String getResponseDate() {
        return this.responseDate;
    }
}

