/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.jsc;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.jsc.JSerialCommChannel;
import io.netty.channel.jsc.JSerialCommChannelConfig;
import io.netty.channel.jsc.JSerialCommChannelOption;
import java.util.Map;

final class DefaultJSerialCommChannelConfig
extends DefaultChannelConfig
implements JSerialCommChannelConfig {
    private volatile int baudrate = 115200;
    private volatile JSerialCommChannelConfig.Stopbits stopbits = JSerialCommChannelConfig.Stopbits.STOPBITS_1;
    private volatile int databits = 8;
    private volatile JSerialCommChannelConfig.Paritybit paritybit = JSerialCommChannelConfig.Paritybit.NONE;
    private volatile int waitTime;
    private volatile int readTimeout = 1000;

    DefaultJSerialCommChannelConfig(JSerialCommChannel channel) {
        super((Channel)channel);
    }

    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), new ChannelOption[]{JSerialCommChannelOption.BAUD_RATE, JSerialCommChannelOption.STOP_BITS, JSerialCommChannelOption.DATA_BITS, JSerialCommChannelOption.PARITY_BIT, JSerialCommChannelOption.WAIT_TIME});
    }

    public <T> T getOption(ChannelOption<T> option) {
        if (option == JSerialCommChannelOption.BAUD_RATE) {
            return (T)Integer.valueOf(this.getBaudrate());
        }
        if (option == JSerialCommChannelOption.STOP_BITS) {
            return (T)((Object)this.getStopbits());
        }
        if (option == JSerialCommChannelOption.DATA_BITS) {
            return (T)Integer.valueOf(this.getDatabits());
        }
        if (option == JSerialCommChannelOption.PARITY_BIT) {
            return (T)((Object)this.getParitybit());
        }
        if (option == JSerialCommChannelOption.WAIT_TIME) {
            return (T)Integer.valueOf(this.getWaitTimeMillis());
        }
        if (option == JSerialCommChannelOption.READ_TIMEOUT) {
            return (T)Integer.valueOf(this.getReadTimeout());
        }
        return (T)super.getOption(option);
    }

    public <T> boolean setOption(ChannelOption<T> option, T value) {
        this.validate(option, value);
        if (option == JSerialCommChannelOption.BAUD_RATE) {
            this.setBaudrate((Integer)value);
        } else if (option == JSerialCommChannelOption.STOP_BITS) {
            this.setStopbits((JSerialCommChannelConfig.Stopbits)((Object)value));
        } else if (option == JSerialCommChannelOption.DATA_BITS) {
            this.setDatabits((Integer)value);
        } else if (option == JSerialCommChannelOption.PARITY_BIT) {
            this.setParitybit((JSerialCommChannelConfig.Paritybit)((Object)value));
        } else if (option == JSerialCommChannelOption.WAIT_TIME) {
            this.setWaitTimeMillis((Integer)value);
        } else if (option == JSerialCommChannelOption.READ_TIMEOUT) {
            this.setReadTimeout((Integer)value);
        } else {
            return super.setOption(option, value);
        }
        return true;
    }

    @Override
    public JSerialCommChannelConfig setBaudrate(int baudrate) {
        this.baudrate = baudrate;
        return this;
    }

    @Override
    public JSerialCommChannelConfig setStopbits(JSerialCommChannelConfig.Stopbits stopbits) {
        this.stopbits = stopbits;
        return this;
    }

    @Override
    public JSerialCommChannelConfig setDatabits(int databits) {
        this.databits = databits;
        return this;
    }

    @Override
    public JSerialCommChannelConfig setParitybit(JSerialCommChannelConfig.Paritybit paritybit) {
        this.paritybit = paritybit;
        return this;
    }

    @Override
    public int getBaudrate() {
        return this.baudrate;
    }

    @Override
    public JSerialCommChannelConfig.Stopbits getStopbits() {
        return this.stopbits;
    }

    @Override
    public int getDatabits() {
        return this.databits;
    }

    @Override
    public JSerialCommChannelConfig.Paritybit getParitybit() {
        return this.paritybit;
    }

    @Override
    public int getWaitTimeMillis() {
        return this.waitTime;
    }

    @Override
    public JSerialCommChannelConfig setWaitTimeMillis(int waitTimeMillis) {
        if (waitTimeMillis < 0) {
            throw new IllegalArgumentException("Wait time must be >= 0");
        }
        this.waitTime = waitTimeMillis;
        return this;
    }

    @Override
    public JSerialCommChannelConfig setReadTimeout(int readTimeout) {
        if (readTimeout < 0) {
            throw new IllegalArgumentException("readTime must be >= 0");
        }
        this.readTimeout = readTimeout;
        return this;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public JSerialCommChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        super.setConnectTimeoutMillis(connectTimeoutMillis);
        return this;
    }

    @Override
    public JSerialCommChannelConfig setWriteSpinCount(int writeSpinCount) {
        super.setWriteSpinCount(writeSpinCount);
        return this;
    }

    @Override
    public JSerialCommChannelConfig setAllocator(ByteBufAllocator allocator) {
        super.setAllocator(allocator);
        return this;
    }

    @Override
    public JSerialCommChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator allocator) {
        super.setRecvByteBufAllocator(allocator);
        return this;
    }

    @Override
    public JSerialCommChannelConfig setAutoRead(boolean autoRead) {
        super.setAutoRead(autoRead);
        return this;
    }

    public JSerialCommChannelConfig setAutoClose(boolean autoClose) {
        super.setAutoClose(autoClose);
        return this;
    }

    @Override
    public JSerialCommChannelConfig setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        super.setWriteBufferHighWaterMark(writeBufferHighWaterMark);
        return this;
    }

    @Override
    public JSerialCommChannelConfig setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        super.setWriteBufferLowWaterMark(writeBufferLowWaterMark);
        return this;
    }

    @Override
    public JSerialCommChannelConfig setMessageSizeEstimator(MessageSizeEstimator estimator) {
        super.setMessageSizeEstimator(estimator);
        return this;
    }
}

