/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.jsc;

import com.fazecast.jSerialComm.SerialPort;
import io.netty.channel.AbstractChannel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.jsc.DefaultJSerialCommChannelConfig;
import io.netty.channel.jsc.JSerialCommChannelConfig;
import io.netty.channel.jsc.JSerialCommChannelOption;
import io.netty.channel.jsc.JSerialCommDeviceAddress;
import io.netty.channel.oio.OioByteStreamChannel;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;

public class JSerialCommChannel
extends OioByteStreamChannel {
    private static final JSerialCommDeviceAddress LOCAL_ADDRESS = new JSerialCommDeviceAddress("localhost");
    private final JSerialCommChannelConfig config = new DefaultJSerialCommChannelConfig(this);
    private boolean open = true;
    private JSerialCommDeviceAddress deviceAddress;
    private SerialPort serialPort;

    public JSerialCommChannel() {
        super(null);
    }

    public JSerialCommChannelConfig config() {
        return this.config;
    }

    public boolean isOpen() {
        return this.open;
    }

    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new JSCUnsafe();
    }

    protected void doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        JSerialCommDeviceAddress remote = (JSerialCommDeviceAddress)remoteAddress;
        SerialPort commPort = SerialPort.getCommPort((String)remote.value());
        if (!commPort.openPort()) {
            throw new IOException("Could not open port: " + remote.value());
        }
        commPort.setComPortTimeouts(256, ((Integer)this.config().getOption(JSerialCommChannelOption.READ_TIMEOUT)).intValue(), 0);
        this.deviceAddress = remote;
        this.serialPort = commPort;
    }

    protected void doInit() throws Exception {
        this.serialPort.setComPortParameters(((Integer)this.config().getOption(JSerialCommChannelOption.BAUD_RATE)).intValue(), ((Integer)this.config().getOption(JSerialCommChannelOption.DATA_BITS)).intValue(), ((JSerialCommChannelConfig.Stopbits)((Object)this.config().getOption(JSerialCommChannelOption.STOP_BITS))).value(), ((JSerialCommChannelConfig.Paritybit)((Object)this.config().getOption(JSerialCommChannelOption.PARITY_BIT))).value());
        this.activate(this.serialPort.getInputStream(), this.serialPort.getOutputStream());
    }

    public JSerialCommDeviceAddress localAddress() {
        return (JSerialCommDeviceAddress)super.localAddress();
    }

    public JSerialCommDeviceAddress remoteAddress() {
        return (JSerialCommDeviceAddress)super.remoteAddress();
    }

    protected JSerialCommDeviceAddress localAddress0() {
        return LOCAL_ADDRESS;
    }

    protected JSerialCommDeviceAddress remoteAddress0() {
        return this.deviceAddress;
    }

    protected void doBind(SocketAddress localAddress) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    protected void doClose() throws Exception {
        this.open = false;
        try {
            super.doClose();
        }
        finally {
            if (this.serialPort != null) {
                this.serialPort.closePort();
                this.serialPort = null;
            }
        }
    }

    protected boolean isInputShutdown() {
        return !this.open;
    }

    protected ChannelFuture shutdownInput() {
        return this.newFailedFuture(new UnsupportedOperationException("shutdownInput"));
    }

    private final class JSCUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private JSCUnsafe() {
            super((AbstractChannel)JSerialCommChannel.this);
        }

        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, final ChannelPromise promise) {
            if (!promise.setUncancellable() || !JSerialCommChannel.this.isOpen()) {
                return;
            }
            try {
                final boolean wasActive = JSerialCommChannel.this.isActive();
                JSerialCommChannel.this.doConnect(remoteAddress, localAddress);
                int waitTime = (Integer)JSerialCommChannel.this.config().getOption(JSerialCommChannelOption.WAIT_TIME);
                if (waitTime > 0) {
                    JSerialCommChannel.this.eventLoop().schedule(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                JSerialCommChannel.this.doInit();
                                JSCUnsafe.this.safeSetSuccess(promise);
                                if (!wasActive && JSerialCommChannel.this.isActive()) {
                                    JSerialCommChannel.this.pipeline().fireChannelActive();
                                }
                            }
                            catch (Throwable t) {
                                JSCUnsafe.this.safeSetFailure(promise, t);
                                JSCUnsafe.this.closeIfClosed();
                            }
                        }
                    }, (long)waitTime, TimeUnit.MILLISECONDS);
                } else {
                    JSerialCommChannel.this.doInit();
                    this.safeSetSuccess(promise);
                    if (!wasActive && JSerialCommChannel.this.isActive()) {
                        JSerialCommChannel.this.pipeline().fireChannelActive();
                    }
                }
            }
            catch (Throwable t) {
                this.safeSetFailure(promise, t);
                this.closeIfClosed();
            }
        }
    }
}

