/*
 * Decompiled with CFR 0.152.
 */
package se.kth.depclean.util;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.kth.depclean.core.AbstractDebloater;
import se.kth.depclean.core.analysis.model.DebloatedDependency;
import se.kth.depclean.core.analysis.model.ProjectDependencyAnalysis;
import se.kth.depclean.core.model.Dependency;

public class MavenDebloater
extends AbstractDebloater<org.apache.maven.model.Dependency> {
    private static final Logger log = LoggerFactory.getLogger(MavenDebloater.class);
    private final MavenProject project;
    private final Model model;
    private final List<org.apache.maven.model.Dependency> initialDependencies;

    public MavenDebloater(ProjectDependencyAnalysis analysis, MavenProject project, Model model) {
        super(analysis);
        this.project = project;
        this.model = model;
        this.initialDependencies = model.getDependencies();
    }

    protected void logDependencies() {
        this.model.getDependencies().forEach(dep -> {
            log.debug("Debloated dependency {}", dep);
            dep.getExclusions().forEach(excl -> log.debug("- Excluding {}:{}", (Object)excl.getGroupId(), (Object)excl.getArtifactId()));
        });
    }

    protected org.apache.maven.model.Dependency toProviderDependency(DebloatedDependency debloatedDependency) {
        org.apache.maven.model.Dependency dependency = this.createDependency((Dependency)debloatedDependency);
        debloatedDependency.getExclusions().forEach(depToExclude -> this.exclude(dependency, (Dependency)depToExclude));
        return dependency;
    }

    protected void setDependencies(List<org.apache.maven.model.Dependency> dependencies) {
        this.model.setDependencies(dependencies);
    }

    private void exclude(org.apache.maven.model.Dependency dependency, Dependency dependencyToExclude) {
        Exclusion exclusion = new Exclusion();
        exclusion.setGroupId(dependencyToExclude.getGroupId());
        exclusion.setArtifactId(dependencyToExclude.getDependencyId());
        dependency.addExclusion(exclusion);
    }

    protected void postProcessDependencies() {
        this.model.getDependencies().forEach(dep -> {
            for (org.apache.maven.model.Dependency initialDependency : this.initialDependencies) {
                if (!this.hasVersionAsProperty(initialDependency) || !this.matches((org.apache.maven.model.Dependency)dep, initialDependency)) continue;
                dep.setVersion(initialDependency.getVersion());
            }
        });
    }

    protected void writeFile() throws IOException {
        String pathToDebloatedPom = this.project.getBasedir().getAbsolutePath() + File.separator + "pom-debloated.xml";
        Path path = Paths.get(pathToDebloatedPom, new String[0]);
        this.writePom(path);
        log.info("POM debloated successfully");
        log.info("pom-debloated.xml file created in: " + pathToDebloatedPom);
    }

    private boolean hasVersionAsProperty(org.apache.maven.model.Dependency initialDependency) {
        if (initialDependency.getVersion() != null) {
            return initialDependency.getVersion().startsWith("$");
        }
        return false;
    }

    private void writePom(Path pomFile) throws IOException {
        MavenXpp3Writer writer = new MavenXpp3Writer();
        writer.write((Writer)Files.newBufferedWriter(pomFile, new OpenOption[0]), this.model);
    }

    private Artifact findArtifact(Dependency dependency) {
        return this.project.getArtifacts().stream().filter(artifact -> this.matches((Artifact)artifact, dependency)).findFirst().orElseThrow(() -> new RuntimeException("Unable to find " + dependency + " in dependencies"));
    }

    private boolean matches(Artifact artifact, Dependency coordinate) {
        return coordinate.toString().toLowerCase().contains(String.format("%s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()).toLowerCase());
    }

    private boolean matches(org.apache.maven.model.Dependency dep, org.apache.maven.model.Dependency initialDependency) {
        return initialDependency.getGroupId().equals(dep.getGroupId()) && initialDependency.getArtifactId().equals(dep.getArtifactId());
    }

    private org.apache.maven.model.Dependency createDependency(Dependency dependency) {
        return this.createDependency(this.findArtifact(dependency));
    }

    private org.apache.maven.model.Dependency createDependency(Artifact artifact) {
        org.apache.maven.model.Dependency dependency = new org.apache.maven.model.Dependency();
        dependency.setGroupId(artifact.getGroupId());
        dependency.setArtifactId(artifact.getArtifactId());
        dependency.setVersion(artifact.getVersion());
        if (artifact.hasClassifier()) {
            dependency.setClassifier(artifact.getClassifier());
        }
        dependency.setOptional(artifact.isOptional());
        dependency.setScope(artifact.getScope());
        dependency.setType(artifact.getType());
        return dependency;
    }
}

