/*
 * Decompiled with CFR 0.152.
 */
package se.kth.depclean.wrapper;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import se.kth.depclean.core.AbstractDebloater;
import se.kth.depclean.core.analysis.graph.DependencyGraph;
import se.kth.depclean.core.analysis.model.ProjectDependencyAnalysis;
import se.kth.depclean.core.analysis.src.ImportsAnalyzer;
import se.kth.depclean.core.wrapper.DependencyManagerWrapper;
import se.kth.depclean.core.wrapper.LogWrapper;
import se.kth.depclean.graph.MavenDependencyGraph;
import se.kth.depclean.util.MavenDebloater;
import se.kth.depclean.util.MavenInvoker;
import se.kth.depclean.util.json.ParsedDependencies;

public class MavenDependencyManager
implements DependencyManagerWrapper {
    private static final String DIRECTORY_TO_COPY_DEPENDENCIES = "dependency";
    private final Log logger;
    private final MavenProject project;
    private final MavenSession session;
    private final DependencyGraphBuilder dependencyGraphBuilder;
    private final Model model;

    public MavenDependencyManager(Log logger, MavenProject project, MavenSession session, DependencyGraphBuilder dependencyGraphBuilder) {
        this.logger = logger;
        this.project = project;
        this.session = session;
        this.dependencyGraphBuilder = dependencyGraphBuilder;
        this.model = this.buildModel(project);
    }

    public LogWrapper getLog() {
        return new LogWrapper(){

            public void info(String message) {
                MavenDependencyManager.this.logger.info((CharSequence)message);
            }

            public void error(String message) {
                MavenDependencyManager.this.logger.error((CharSequence)message);
            }

            public void debug(String message) {
                MavenDependencyManager.this.logger.debug((CharSequence)message);
            }
        };
    }

    public boolean isMaven() {
        return true;
    }

    public boolean isPackagingPom() {
        return this.project.getPackaging().equals("pom");
    }

    public DependencyGraph dependencyGraph() {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setProject(this.project);
        DependencyNode rootNode = this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, null);
        return new MavenDependencyGraph(this.project, this.model, rootNode);
    }

    public Set<Path> getOutputDirectories() {
        return Set.of(Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]));
    }

    public Set<Path> getTestOutputDirectories() {
        return Set.of(Paths.get(this.project.getBuild().getTestOutputDirectory(), new String[0]));
    }

    private Model buildModel(MavenProject project) {
        Model model;
        File pomFile = new File(project.getBasedir().getAbsolutePath() + File.separator + "pom.xml");
        MavenXpp3Reader mavenReader = new MavenXpp3Reader();
        try {
            FileReader reader = new FileReader(pomFile);
            model = mavenReader.read((Reader)reader);
            model.setPomFile(pomFile);
        }
        catch (Exception ex) {
            this.getLog().error("Unable to build the maven project.");
            throw new RuntimeException(ex);
        }
        return model;
    }

    public Set<String> collectUsedClassesFromProcessors() {
        this.getLog().debug("# collectUsedClassesFromProcessors()");
        return Optional.ofNullable(this.project.getPlugin("org.bsc.maven:maven-processor-plugin")).map(plugin -> (PluginExecution)plugin.getExecutionsAsMap().get("process")).map(exec -> (Xpp3Dom)exec.getConfiguration()).map(config -> config.getChild("processors")).map(Xpp3Dom::getChildren).map(arr -> Arrays.stream(arr).map(Xpp3Dom::getValue).collect(Collectors.toSet())).orElse((Set)ImmutableSet.of());
    }

    public Path getDependenciesDirectory() {
        String dependencyDirectoryName = this.project.getBuild().getDirectory() + "/dependency";
        return new File(dependencyDirectoryName).toPath();
    }

    public Set<String> collectUsedClassesFromSource(Path sourceDirectory, Path testSourceDirectory) {
        HashSet<String> allImports = new HashSet<String>();
        ImportsAnalyzer importsInSourceFolder = new ImportsAnalyzer(sourceDirectory);
        ImportsAnalyzer importsInTestsFolder = new ImportsAnalyzer(testSourceDirectory);
        Set importsInSourceFolderSet = importsInSourceFolder.collectImportedClassesFromSource();
        Set importsInTestsFolderSet = importsInTestsFolder.collectImportedClassesFromSource();
        allImports.addAll(importsInSourceFolderSet);
        allImports.addAll(importsInTestsFolderSet);
        return allImports;
    }

    public AbstractDebloater<? extends Serializable> getDebloater(ProjectDependencyAnalysis analysis) {
        return new MavenDebloater(analysis, this.project, this.model);
    }

    public Path getBuildDirectory() {
        return Paths.get(this.project.getBuild().getDirectory(), new String[0]);
    }

    public Path getSourceDirectory() {
        return new File(this.project.getBuild().getSourceDirectory()).toPath();
    }

    public Path getTestDirectory() {
        return new File(this.project.getBuild().getTestSourceDirectory()).toPath();
    }

    public void generateDependencyTree(File treeFile) throws IOException, InterruptedException {
        MavenInvoker.runCommand("mvn dependency:tree -DoutputFile=" + String.valueOf(treeFile) + " -Dverbose=true", null);
    }

    public String getTreeAsJson(File treeFile, ProjectDependencyAnalysis analysis, File classUsageFile, boolean createCallGraphCsv) {
        return new ParsedDependencies(treeFile, analysis, classUsageFile, createCallGraphCsv).parseTreeToJson();
    }

    @ConstructorProperties(value={"logger", "project", "session", "dependencyGraphBuilder", "model"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MavenDependencyManager(Log logger, MavenProject project, MavenSession session, DependencyGraphBuilder dependencyGraphBuilder, Model model) {
        this.logger = logger;
        this.project = project;
        this.session = session;
        this.dependencyGraphBuilder = dependencyGraphBuilder;
        this.model = model;
    }
}

