/*
 * Decompiled with CFR 0.152.
 */
package se.kuseman.payloadbuilder.api.execution.vector;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import se.kuseman.payloadbuilder.api.catalog.Column;
import se.kuseman.payloadbuilder.api.catalog.Schema;
import se.kuseman.payloadbuilder.api.execution.TupleVector;
import se.kuseman.payloadbuilder.api.execution.UTF8String;
import se.kuseman.payloadbuilder.api.execution.vector.ChainedTupleVector;
import se.kuseman.payloadbuilder.test.VectorTestUtils;

public class ChainedTupleVectorTest
extends Assert {
    @Test
    public void test_no_common_schema_sub_Set() {
        VectorTestUtils.assertTupleVectorsEquals(TupleVector.EMPTY, ChainedTupleVector.chain(List.of()));
        TupleVector tv1 = TupleVector.of((Schema)Schema.of((Column[])new Column[]{Column.of((String)"col1", (Column.Type)Column.Type.Int), Column.of((String)"col2", (Column.Type)Column.Type.Boolean)}), List.of(VectorTestUtils.vv(Column.Type.Int, 1, 2, 3), VectorTestUtils.vv(Column.Type.Boolean, null, true, false)));
        TupleVector tv2 = TupleVector.of((Schema)Schema.of((Column[])new Column[]{Column.of((String)"col1", (Column.Type)Column.Type.Float), Column.of((String)"col2", (Column.Type)Column.Type.Boolean)}), List.of(VectorTestUtils.vv(Column.Type.Float, 1, 2, 3), VectorTestUtils.vv(Column.Type.Boolean, null, true, false)));
        try {
            ChainedTupleVector.chain(List.of(tv1, tv2));
            ChainedTupleVectorTest.fail((String)"Should fail cause of failed chain");
        }
        catch (IllegalArgumentException e) {
            ChainedTupleVectorTest.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Schema of chained tuple vectors must share a common sub set of columns."));
        }
    }

    @Test
    public void test_no_or_single_vectors() {
        VectorTestUtils.assertTupleVectorsEquals(TupleVector.EMPTY, ChainedTupleVector.chain(List.of()));
        TupleVector tv1 = TupleVector.of((Schema)Schema.of((Column[])new Column[]{Column.of((String)"col1", (Column.Type)Column.Type.Int), Column.of((String)"col2", (Column.Type)Column.Type.Boolean)}), List.of(VectorTestUtils.vv(Column.Type.Int, 1, 2, 3), VectorTestUtils.vv(Column.Type.Boolean, null, true, false)));
        ChainedTupleVectorTest.assertSame((Object)tv1, (Object)ChainedTupleVector.chain(List.of(tv1)));
    }

    @Test
    public void test_chain_same_schema_vectors() {
        VectorTestUtils.assertTupleVectorsEquals(TupleVector.EMPTY, ChainedTupleVector.chain(List.of()));
        TupleVector tv1 = TupleVector.of((Schema)Schema.of((Column[])new Column[]{Column.of((String)"col1", (Column.Type)Column.Type.Int), Column.of((String)"col2", (Column.Type)Column.Type.Boolean)}), List.of(VectorTestUtils.vv(Column.Type.Int, 1, 2, 3), VectorTestUtils.vv(Column.Type.Boolean, null, true, false)));
        TupleVector tv2 = TupleVector.of((Schema)tv1.getSchema(), List.of(VectorTestUtils.vv(Column.Type.Int, 1, 2, 3), VectorTestUtils.vv(Column.Type.Boolean, null, true, false)));
        ChainedTupleVectorTest.assertSame((Object)tv1.getSchema(), (Object)ChainedTupleVector.chain(List.of(tv1, tv2)).getSchema());
    }

    @Test
    public void test() {
        TupleVector tv1 = TupleVector.of((Schema)Schema.of((Column[])new Column[]{Column.of((String)"col1", (Column.Type)Column.Type.Int), Column.of((String)"col2", (Column.Type)Column.Type.Boolean)}), List.of(VectorTestUtils.vv(Column.Type.Int, 1, 2, 3), VectorTestUtils.vv(Column.Type.Boolean, null, true, false)));
        TupleVector tv2 = TupleVector.of((Schema)Schema.of((Column[])new Column[]{Column.of((String)"col1", (Column.Type)Column.Type.Int)}), List.of(VectorTestUtils.vv(Column.Type.Int, 10, null, 30)));
        TupleVector tv3 = TupleVector.of((Schema)Schema.of((Column[])new Column[]{Column.of((String)"col1", (Column.Type)Column.Type.Int), Column.of((String)"col2", (Column.Type)Column.Type.Boolean), Column.of((String)"col3", (Column.Type)Column.Type.String)}), List.of(VectorTestUtils.vv(Column.Type.Int, 100, null), VectorTestUtils.vv(Column.Type.Boolean, true, false), VectorTestUtils.vv(Column.Type.String, "hello", "world")));
        TupleVector actual = ChainedTupleVector.chain(List.of(tv1, tv2, tv3));
        VectorTestUtils.assertTupleVectorsEquals(TupleVector.of((Schema)Schema.of((Column[])new Column[]{Column.of((String)"col1", (Column.Type)Column.Type.Int), Column.of((String)"col2", (Column.Type)Column.Type.Boolean), Column.of((String)"col3", (Column.Type)Column.Type.String)}), List.of(VectorTestUtils.vv(Column.Type.Int, 1, 2, 3, 10, null, 30, 100, null), VectorTestUtils.vv(Column.Type.Boolean, null, true, false, null, null, null, true, false), VectorTestUtils.vv(Column.Type.String, null, null, null, null, null, null, "hello", "world"))), actual);
        ChainedTupleVectorTest.assertEquals((long)1L, (long)actual.getColumn(0).getInt(0));
        ChainedTupleVectorTest.assertEquals((Object)UTF8String.from((String)"world"), (Object)actual.getColumn(2).getString(7));
    }

    @Test
    public void test_all_get_methods_are_declared() {
        List methods = Arrays.stream(Column.Type.values()).map(t -> "get" + String.valueOf(t)).collect(Collectors.toList());
        for (String method : methods) {
            try {
                ChainedTupleVector.ChainedValueVector.class.getDeclaredMethod(method, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                ChainedTupleVectorTest.fail((String)(ChainedTupleVector.ChainedValueVector.class.getSimpleName() + " should have method: " + method));
            }
        }
    }
}

