/*
 * Decompiled with CFR 0.152.
 */
package se.kuseman.payloadbuilder.test;

import java.util.List;
import java.util.Objects;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import se.kuseman.payloadbuilder.api.QualifiedName;
import se.kuseman.payloadbuilder.api.catalog.Column;
import se.kuseman.payloadbuilder.api.catalog.ResolvedType;
import se.kuseman.payloadbuilder.api.catalog.ScalarFunctionInfo;
import se.kuseman.payloadbuilder.api.execution.Decimal;
import se.kuseman.payloadbuilder.api.execution.EpochDateTime;
import se.kuseman.payloadbuilder.api.execution.EpochDateTimeOffset;
import se.kuseman.payloadbuilder.api.execution.IExecutionContext;
import se.kuseman.payloadbuilder.api.execution.UTF8String;
import se.kuseman.payloadbuilder.api.expression.IArithmeticBinaryExpression;
import se.kuseman.payloadbuilder.api.expression.IColumnExpression;
import se.kuseman.payloadbuilder.api.expression.IComparisonExpression;
import se.kuseman.payloadbuilder.api.expression.IDereferenceExpression;
import se.kuseman.payloadbuilder.api.expression.IExpression;
import se.kuseman.payloadbuilder.api.expression.IExpressionVisitor;
import se.kuseman.payloadbuilder.api.expression.IFunctionCallExpression;
import se.kuseman.payloadbuilder.api.expression.IInExpression;
import se.kuseman.payloadbuilder.api.expression.ILiteralBooleanExpression;
import se.kuseman.payloadbuilder.api.expression.ILiteralDateTimeExpression;
import se.kuseman.payloadbuilder.api.expression.ILiteralDateTimeOffsetExpression;
import se.kuseman.payloadbuilder.api.expression.ILiteralDecimalExpression;
import se.kuseman.payloadbuilder.api.expression.ILiteralDoubleExpression;
import se.kuseman.payloadbuilder.api.expression.ILiteralFloatExpression;
import se.kuseman.payloadbuilder.api.expression.ILiteralIntegerExpression;
import se.kuseman.payloadbuilder.api.expression.ILiteralLongExpression;
import se.kuseman.payloadbuilder.api.expression.ILiteralNullExpression;
import se.kuseman.payloadbuilder.api.expression.ILiteralStringExpression;
import se.kuseman.payloadbuilder.api.expression.ILogicalBinaryExpression;
import se.kuseman.payloadbuilder.api.expression.ILogicalNotExpression;
import se.kuseman.payloadbuilder.api.expression.INullPredicateExpression;
import se.kuseman.payloadbuilder.api.expression.IVariableExpression;
import se.kuseman.payloadbuilder.test.VectorTestUtils;

public class ExpressionTestUtils {
    public static ILiteralStringExpression createStringExpression(String value) {
        Objects.requireNonNull(value);
        ILiteralStringExpression mock = (ILiteralStringExpression)Mockito.mock(ILiteralStringExpression.class);
        Mockito.when((Object)mock.eval((IExecutionContext)ArgumentMatchers.any(IExecutionContext.class))).thenReturn((Object)VectorTestUtils.vv(Column.Type.String, value));
        Mockito.when((Object)mock.getValue()).thenReturn((Object)UTF8String.from((String)value));
        Mockito.when((Object)mock.toString()).thenReturn((Object)value);
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)mock.getType()).thenReturn((Object)ResolvedType.of((Column.Type)Column.Type.String));
        return mock;
    }

    public static ILiteralIntegerExpression createIntegerExpression(int value) {
        ILiteralIntegerExpression mock = (ILiteralIntegerExpression)Mockito.mock(ILiteralIntegerExpression.class);
        Mockito.when((Object)mock.eval((IExecutionContext)ArgumentMatchers.any(IExecutionContext.class))).thenReturn((Object)VectorTestUtils.vv(Column.Type.Int, value));
        Mockito.when((Object)mock.getValue()).thenReturn((Object)value);
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)mock.getType()).thenReturn((Object)ResolvedType.of((Column.Type)Column.Type.Int));
        return mock;
    }

    public static ILiteralLongExpression createLongExpression(long value) {
        ILiteralLongExpression mock = (ILiteralLongExpression)Mockito.mock(ILiteralLongExpression.class);
        Mockito.when((Object)mock.eval((IExecutionContext)ArgumentMatchers.any(IExecutionContext.class))).thenReturn((Object)VectorTestUtils.vv(Column.Type.Long, value));
        Mockito.when((Object)mock.getValue()).thenReturn((Object)value);
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)mock.getType()).thenReturn((Object)ResolvedType.of((Column.Type)Column.Type.Long));
        return mock;
    }

    public static ILiteralFloatExpression createFloatExpression(float value) {
        ILiteralFloatExpression mock = (ILiteralFloatExpression)Mockito.mock(ILiteralFloatExpression.class);
        Mockito.when((Object)mock.eval((IExecutionContext)ArgumentMatchers.any(IExecutionContext.class))).thenReturn((Object)VectorTestUtils.vv(Column.Type.Float, Float.valueOf(value)));
        Mockito.when((Object)Float.valueOf(mock.getValue())).thenReturn((Object)Float.valueOf(value));
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)mock.getType()).thenReturn((Object)ResolvedType.of((Column.Type)Column.Type.Float));
        return mock;
    }

    public static ILiteralDoubleExpression createDoubleExpression(double value) {
        ILiteralDoubleExpression mock = (ILiteralDoubleExpression)Mockito.mock(ILiteralDoubleExpression.class);
        Mockito.when((Object)mock.eval((IExecutionContext)ArgumentMatchers.any(IExecutionContext.class))).thenReturn((Object)VectorTestUtils.vv(Column.Type.Double, value));
        Mockito.when((Object)mock.getValue()).thenReturn((Object)value);
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)mock.getType()).thenReturn((Object)ResolvedType.of((Column.Type)Column.Type.Double));
        return mock;
    }

    public static ILiteralBooleanExpression createBooleanExpression(boolean value) {
        ILiteralBooleanExpression mock = (ILiteralBooleanExpression)Mockito.mock(ILiteralBooleanExpression.class);
        Mockito.when((Object)mock.eval((IExecutionContext)ArgumentMatchers.any(IExecutionContext.class))).thenReturn((Object)VectorTestUtils.vv(Column.Type.Boolean, value));
        Mockito.when((Object)mock.getValue()).thenReturn((Object)value);
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)mock.getType()).thenReturn((Object)ResolvedType.of((Column.Type)Column.Type.Boolean));
        return mock;
    }

    public static ILiteralDecimalExpression createDecimalExpression(Decimal value) {
        ILiteralDecimalExpression mock = (ILiteralDecimalExpression)Mockito.mock(ILiteralDecimalExpression.class);
        Mockito.when((Object)mock.eval((IExecutionContext)ArgumentMatchers.any(IExecutionContext.class))).thenReturn((Object)VectorTestUtils.vv(Column.Type.Decimal, value));
        Mockito.when((Object)mock.getValue()).thenReturn((Object)value);
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)mock.getType()).thenReturn((Object)ResolvedType.of((Column.Type)Column.Type.Decimal));
        return mock;
    }

    public static ILiteralDateTimeExpression createDateTimeExpression(EpochDateTime value) {
        ILiteralDateTimeExpression mock = (ILiteralDateTimeExpression)Mockito.mock(ILiteralDateTimeExpression.class);
        Mockito.when((Object)mock.eval((IExecutionContext)ArgumentMatchers.any(IExecutionContext.class))).thenReturn((Object)VectorTestUtils.vv(Column.Type.DateTime, value));
        Mockito.when((Object)mock.getValue()).thenReturn((Object)value);
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)mock.getType()).thenReturn((Object)ResolvedType.of((Column.Type)Column.Type.DateTime));
        return mock;
    }

    public static ILiteralDateTimeOffsetExpression createDateTimeOffsetExpression(EpochDateTimeOffset value) {
        ILiteralDateTimeOffsetExpression mock = (ILiteralDateTimeOffsetExpression)Mockito.mock(ILiteralDateTimeOffsetExpression.class);
        Mockito.when((Object)mock.eval((IExecutionContext)ArgumentMatchers.any(IExecutionContext.class))).thenReturn((Object)VectorTestUtils.vv(Column.Type.DateTimeOffset, value));
        Mockito.when((Object)mock.getValue()).thenReturn((Object)value);
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)mock.getType()).thenReturn((Object)ResolvedType.of((Column.Type)Column.Type.DateTimeOffset));
        return mock;
    }

    public static ILiteralNullExpression createNullExpression() {
        ILiteralNullExpression mock = (ILiteralNullExpression)Mockito.mock(ILiteralNullExpression.class);
        Mockito.when((Object)mock.eval((IExecutionContext)ArgumentMatchers.any(IExecutionContext.class))).thenReturn((Object)VectorTestUtils.vv(Column.Type.Any, new Object[]{null}));
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)mock.getType()).thenReturn((Object)ResolvedType.of((Column.Type)Column.Type.Any));
        return mock;
    }

    public static IVariableExpression var(String name, Object value) {
        IVariableExpression mock = (IVariableExpression)Mockito.mock(IVariableExpression.class);
        Mockito.when((Object)mock.eval((IExecutionContext)ArgumentMatchers.any(IExecutionContext.class))).thenReturn((Object)VectorTestUtils.vv(Column.Type.Any, value));
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)mock.getName()).thenReturn((Object)name);
        Mockito.when((Object)mock.getType()).thenReturn((Object)ResolvedType.of((Column.Type)Column.Type.Any));
        return mock;
    }

    public static INullPredicateExpression isnull(IExpression expression) {
        INullPredicateExpression mock = (INullPredicateExpression)Mockito.mock(INullPredicateExpression.class);
        Mockito.when((Object)mock.getExpression()).thenReturn((Object)expression);
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)mock.isNot()).thenReturn((Object)false);
        Mockito.when((Object)mock.getType()).thenReturn((Object)ResolvedType.of((Column.Type)Column.Type.Boolean));
        return mock;
    }

    public static INullPredicateExpression isnotnull(IExpression expression) {
        INullPredicateExpression mock = (INullPredicateExpression)Mockito.mock(INullPredicateExpression.class);
        Mockito.when((Object)mock.getExpression()).thenReturn((Object)expression);
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)mock.isNot()).thenReturn((Object)true);
        Mockito.when((Object)mock.getType()).thenReturn((Object)ResolvedType.of((Column.Type)Column.Type.Boolean));
        return mock;
    }

    public static IComparisonExpression ce(IComparisonExpression.Type type, IExpression left, IExpression right) {
        IComparisonExpression mock = (IComparisonExpression)Mockito.mock(IComparisonExpression.class);
        Mockito.when((Object)mock.getLeft()).thenReturn((Object)left);
        Mockito.when((Object)mock.getRight()).thenReturn((Object)right);
        Mockito.when((Object)mock.getComparisonType()).thenReturn((Object)type);
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)mock.getType()).thenReturn((Object)ResolvedType.of((Column.Type)Column.Type.Boolean));
        return mock;
    }

    public static ILogicalBinaryExpression and(IExpression left, IExpression right) {
        ILogicalBinaryExpression mock = (ILogicalBinaryExpression)Mockito.mock(ILogicalBinaryExpression.class);
        Mockito.when((Object)mock.getLeft()).thenReturn((Object)left);
        Mockito.when((Object)mock.getRight()).thenReturn((Object)right);
        Mockito.when((Object)mock.getLogicalType()).thenReturn((Object)ILogicalBinaryExpression.Type.AND);
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)mock.getType()).thenReturn((Object)ResolvedType.of((Column.Type)Column.Type.Boolean));
        return mock;
    }

    public static ILogicalBinaryExpression or(IExpression left, IExpression right) {
        ILogicalBinaryExpression mock = (ILogicalBinaryExpression)Mockito.mock(ILogicalBinaryExpression.class);
        Mockito.when((Object)mock.getLeft()).thenReturn((Object)left);
        Mockito.when((Object)mock.getRight()).thenReturn((Object)right);
        Mockito.when((Object)mock.getLogicalType()).thenReturn((Object)ILogicalBinaryExpression.Type.OR);
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)mock.getType()).thenReturn((Object)ResolvedType.of((Column.Type)Column.Type.Boolean));
        return mock;
    }

    public static ILogicalNotExpression not(IExpression expression) {
        ILogicalNotExpression mock = (ILogicalNotExpression)Mockito.mock(ILogicalNotExpression.class);
        Mockito.when((Object)mock.getExpression()).thenReturn((Object)expression);
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)mock.getType()).thenReturn((Object)ResolvedType.of((Column.Type)Column.Type.Boolean));
        return mock;
    }

    public static IArithmeticBinaryExpression arit(IArithmeticBinaryExpression.Type type, IExpression left, IExpression right) {
        IArithmeticBinaryExpression mock = (IArithmeticBinaryExpression)Mockito.mock(IArithmeticBinaryExpression.class);
        Mockito.when((Object)mock.getLeft()).thenReturn((Object)left);
        Mockito.when((Object)mock.getRight()).thenReturn((Object)right);
        Mockito.when((Object)mock.getArithmeticType()).thenReturn((Object)type);
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        return mock;
    }

    public static IDereferenceExpression deref(IExpression left, String right) {
        IDereferenceExpression mock = (IDereferenceExpression)Mockito.mock(IDereferenceExpression.class);
        Mockito.when((Object)mock.getExpression()).thenReturn((Object)left);
        Mockito.when((Object)mock.getRight()).thenReturn((Object)right);
        Mockito.when((Object)mock.getQualifiedColumn()).thenCallRealMethod();
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        return mock;
    }

    public static IInExpression in(IExpression expression, List<IExpression> arguments) {
        IInExpression mock = (IInExpression)Mockito.mock(IInExpression.class);
        Mockito.when((Object)mock.getExpression()).thenReturn((Object)expression);
        Mockito.when((Object)mock.getArguments()).thenReturn(arguments);
        Mockito.when((Object)mock.isNot()).thenReturn((Object)false);
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)mock.getType()).thenReturn((Object)ResolvedType.of((Column.Type)Column.Type.Boolean));
        return mock;
    }

    public static IInExpression notIn(IExpression expression, List<IExpression> arguments) {
        IInExpression mock = (IInExpression)Mockito.mock(IInExpression.class);
        Mockito.when((Object)mock.getExpression()).thenReturn((Object)expression);
        Mockito.when((Object)mock.getArguments()).thenReturn(arguments);
        Mockito.when((Object)mock.isNot()).thenReturn((Object)true);
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)mock.getType()).thenReturn((Object)ResolvedType.of((Column.Type)Column.Type.Boolean));
        return mock;
    }

    public static IColumnExpression col(String column) {
        IColumnExpression mock = (IColumnExpression)Mockito.mock(IColumnExpression.class);
        Mockito.when((Object)mock.getColumn()).thenReturn((Object)column);
        Mockito.when((Object)mock.getQualifiedColumn()).thenReturn((Object)QualifiedName.of((Object)column));
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        return mock;
    }

    public static IExpression col(QualifiedName column) {
        if (column.size() == 1) {
            return ExpressionTestUtils.col(column.getFirst());
        }
        Object result = null;
        for (int i = 0; i < column.size(); ++i) {
            result = result == null ? ExpressionTestUtils.col((String)column.getParts().get(i)) : ExpressionTestUtils.deref((IExpression)result, (String)column.getParts().get(i));
        }
        return result;
    }

    public static IFunctionCallExpression function(String catalogAlias, String functionName, List<IExpression> arguments, Object result) {
        IFunctionCallExpression functionExpression = (IFunctionCallExpression)Mockito.mock(IFunctionCallExpression.class);
        ((IFunctionCallExpression)Mockito.doCallRealMethod().when((Object)functionExpression)).accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any());
        ScalarFunctionInfo functionInfo = (ScalarFunctionInfo)Mockito.mock(ScalarFunctionInfo.class);
        Mockito.when((Object)functionInfo.getName()).thenReturn((Object)functionName);
        Mockito.when((Object)functionExpression.getCatalogAlias()).thenReturn((Object)catalogAlias);
        Mockito.when((Object)functionExpression.getFunctionInfo()).thenReturn((Object)functionInfo);
        Mockito.when((Object)functionExpression.getArguments()).thenReturn(arguments);
        Mockito.when((Object)functionExpression.eval((IExecutionContext)ArgumentMatchers.any(IExecutionContext.class))).thenReturn((Object)VectorTestUtils.vv(Column.Type.Any, result));
        return functionExpression;
    }
}

