/*
 * Decompiled with CFR 0.152.
 */
package se.kuseman.payloadbuilder.test;

import java.util.List;
import java.util.stream.Collectors;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import se.kuseman.payloadbuilder.api.QualifiedName;
import se.kuseman.payloadbuilder.api.catalog.Column;
import se.kuseman.payloadbuilder.api.catalog.IPredicate;
import se.kuseman.payloadbuilder.api.catalog.ResolvedType;
import se.kuseman.payloadbuilder.api.catalog.ScalarFunctionInfo;
import se.kuseman.payloadbuilder.api.execution.IExecutionContext;
import se.kuseman.payloadbuilder.api.execution.TupleVector;
import se.kuseman.payloadbuilder.api.execution.UTF8String;
import se.kuseman.payloadbuilder.api.execution.ValueVector;
import se.kuseman.payloadbuilder.api.expression.IColumnExpression;
import se.kuseman.payloadbuilder.api.expression.IComparisonExpression;
import se.kuseman.payloadbuilder.api.expression.IExpression;
import se.kuseman.payloadbuilder.api.expression.IExpressionVisitor;
import se.kuseman.payloadbuilder.api.expression.IFunctionCallExpression;
import se.kuseman.payloadbuilder.api.expression.IInExpression;
import se.kuseman.payloadbuilder.api.expression.ILikeExpression;
import se.kuseman.payloadbuilder.api.expression.ILiteralBooleanExpression;
import se.kuseman.payloadbuilder.api.expression.ILiteralDoubleExpression;
import se.kuseman.payloadbuilder.api.expression.ILiteralFloatExpression;
import se.kuseman.payloadbuilder.api.expression.ILiteralIntegerExpression;
import se.kuseman.payloadbuilder.api.expression.ILiteralLongExpression;
import se.kuseman.payloadbuilder.api.expression.ILiteralNullExpression;
import se.kuseman.payloadbuilder.api.expression.ILiteralStringExpression;
import se.kuseman.payloadbuilder.api.expression.INullPredicateExpression;

public class IPredicateMock {
    public static IPredicate undefined(IExpression expression) {
        IPredicate mock = (IPredicate)Mockito.mock(IPredicate.class);
        Mockito.when((Object)mock.getFullExpression()).thenReturn((Object)expression);
        Mockito.when((Object)mock.getUndefinedExpression()).thenReturn((Object)expression);
        Mockito.when((Object)mock.getType()).thenReturn((Object)IPredicate.Type.UNDEFINED);
        String toString = expression.toString();
        Mockito.when((Object)mock.getSqlRepresentation()).thenReturn((Object)toString);
        return mock;
    }

    public static IPredicate neq(String column, Object value) {
        return IPredicateMock.comparison(QualifiedName.of((Object)column), value, IComparisonExpression.Type.NOT_EQUAL);
    }

    public static IPredicate eq(String column, Object value) {
        return IPredicateMock.comparison(QualifiedName.of((Object)column), value, IComparisonExpression.Type.EQUAL);
    }

    public static IPredicate gt(String column, Object value) {
        return IPredicateMock.comparison(QualifiedName.of((Object)column), value, IComparisonExpression.Type.GREATER_THAN);
    }

    public static IPredicate gte(String column, Object value) {
        return IPredicateMock.comparison(QualifiedName.of((Object)column), value, IComparisonExpression.Type.GREATER_THAN_EQUAL);
    }

    public static IPredicate lt(String column, Object value) {
        return IPredicateMock.comparison(QualifiedName.of((Object)column), value, IComparisonExpression.Type.LESS_THAN);
    }

    public static IPredicate lte(String column, Object value) {
        return IPredicateMock.comparison(QualifiedName.of((Object)column), value, IComparisonExpression.Type.LESS_THAN_EQUAL);
    }

    public static IPredicate comparison(QualifiedName column, Object value, IComparisonExpression.Type type) {
        IPredicate pair = (IPredicate)Mockito.mock(IPredicate.class);
        Mockito.when((Object)pair.getQualifiedColumn()).thenReturn((Object)column);
        Mockito.when((Object)pair.getType()).thenReturn((Object)IPredicate.Type.COMPARISION);
        Mockito.when((Object)pair.getComparisonType()).thenReturn((Object)type);
        IComparisonExpression comparisonExpression = IPredicateMock.expression(value, IComparisonExpression.class);
        Mockito.when((Object)comparisonExpression.getComparisonType()).thenReturn((Object)type);
        IExpression left = IPredicateMock.column(column, value);
        IExpression right = IPredicateMock.expression(value);
        Mockito.when((Object)comparisonExpression.getLeft()).thenReturn((Object)left);
        Mockito.when((Object)comparisonExpression.getRight()).thenReturn((Object)right);
        ((IComparisonExpression)Mockito.doCallRealMethod().when((Object)comparisonExpression)).accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any());
        Mockito.when((Object)pair.getFullExpression()).thenReturn((Object)comparisonExpression);
        Mockito.when((Object)pair.getComparisonExpression()).thenReturn((Object)comparisonExpression);
        return pair;
    }

    public static IPredicate in(String column, List<Object> values) {
        return IPredicateMock.inPair(column, false, values);
    }

    public static IPredicate notIn(String column, List<Object> values) {
        return IPredicateMock.inPair(column, true, values);
    }

    public static IPredicate _null(String column, boolean not) {
        IPredicate pair = (IPredicate)Mockito.mock(IPredicate.class);
        Mockito.when((Object)pair.getQualifiedColumn()).thenReturn((Object)QualifiedName.of((Object)column));
        Mockito.when((Object)pair.getType()).thenReturn((Object)IPredicate.Type.NULL);
        INullPredicateExpression expression = (INullPredicateExpression)Mockito.mock(INullPredicateExpression.class);
        ((INullPredicateExpression)Mockito.doCallRealMethod().when((Object)expression)).accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any());
        Mockito.when((Object)pair.getNullPredicateExpression()).thenReturn((Object)expression);
        Mockito.when((Object)pair.getFullExpression()).thenReturn((Object)expression);
        Mockito.when((Object)expression.isNot()).thenReturn((Object)not);
        return pair;
    }

    public static IPredicate inPair(String column, boolean not, List<Object> values) {
        IPredicate pair = (IPredicate)Mockito.mock(IPredicate.class);
        Mockito.when((Object)pair.getQualifiedColumn()).thenReturn((Object)QualifiedName.of((Object)column));
        Mockito.when((Object)pair.getType()).thenReturn((Object)IPredicate.Type.IN);
        IInExpression inExpression = (IInExpression)Mockito.mock(IInExpression.class);
        Mockito.when((Object)pair.getInExpression()).thenReturn((Object)inExpression);
        Mockito.when((Object)pair.getFullExpression()).thenReturn((Object)inExpression);
        ((IInExpression)Mockito.doCallRealMethod().when((Object)inExpression)).accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any());
        Mockito.when((Object)inExpression.isNot()).thenReturn((Object)not);
        IExpression expression = (IExpression)Mockito.mock(IExpression.class);
        Mockito.when((Object)expression.getQualifiedColumn()).thenReturn((Object)QualifiedName.of((Object)column));
        Mockito.when((Object)inExpression.getExpression()).thenReturn((Object)expression);
        final List arguments = values.stream().map(v -> IPredicateMock.expression(v)).collect(Collectors.toList());
        Mockito.when((Object)inExpression.getArguments()).then((Answer)new Answer<List<IExpression>>(){

            public List<IExpression> answer(InvocationOnMock invocation) throws Throwable {
                return arguments;
            }
        });
        return pair;
    }

    public static IPredicate like(String column, String likePattern) {
        return IPredicateMock.likePair(column, false, likePattern);
    }

    public static IPredicate notLike(String column, String likePattern) {
        return IPredicateMock.likePair(column, true, likePattern);
    }

    public static IPredicate likePair(String column, boolean not, String likePattern) {
        IPredicate pair = (IPredicate)Mockito.mock(IPredicate.class);
        Mockito.when((Object)pair.getQualifiedColumn()).thenReturn((Object)QualifiedName.of((Object)column));
        Mockito.when((Object)pair.getType()).thenReturn((Object)IPredicate.Type.LIKE);
        ILikeExpression likeExpression = (ILikeExpression)Mockito.mock(ILikeExpression.class);
        ((ILikeExpression)Mockito.doCallRealMethod().when((Object)likeExpression)).accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any());
        Mockito.when((Object)pair.getLikeExpression()).thenReturn((Object)likeExpression);
        Mockito.when((Object)pair.getFullExpression()).thenReturn((Object)likeExpression);
        Mockito.when((Object)likeExpression.isNot()).thenReturn((Object)not);
        IExpression pattern = IPredicateMock.expression(likePattern);
        Mockito.when((Object)likeExpression.getPatternExpression()).thenReturn((Object)pattern);
        return pair;
    }

    public static IPredicate function(String catalogAlias, String functionName, List<Object> arguments) {
        IPredicate predicate = (IPredicate)Mockito.mock(IPredicate.class);
        Mockito.when((Object)predicate.getType()).thenReturn((Object)IPredicate.Type.FUNCTION_CALL);
        IFunctionCallExpression functionExpression = (IFunctionCallExpression)Mockito.mock(IFunctionCallExpression.class);
        ((IFunctionCallExpression)Mockito.doCallRealMethod().when((Object)functionExpression)).accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any());
        ScalarFunctionInfo functionInfo = (ScalarFunctionInfo)Mockito.mock(ScalarFunctionInfo.class);
        Mockito.when((Object)functionInfo.getName()).thenReturn((Object)functionName);
        Mockito.when((Object)predicate.getFunctionCallExpression()).thenReturn((Object)functionExpression);
        Mockito.when((Object)predicate.getFullExpression()).thenReturn((Object)functionExpression);
        Mockito.when((Object)functionExpression.getCatalogAlias()).thenReturn((Object)catalogAlias);
        Mockito.when((Object)functionExpression.getFunctionInfo()).thenReturn((Object)functionInfo);
        final List functionArguments = arguments.stream().map(v -> v instanceof IExpression ? (IExpression)v : IPredicateMock.expression(v)).collect(Collectors.toList());
        Mockito.when((Object)functionExpression.getArguments()).then((Answer)new Answer<List<IExpression>>(){

            public List<IExpression> answer(InvocationOnMock invocation) throws Throwable {
                return functionArguments;
            }
        });
        return predicate;
    }

    public static IExpression expression(Object value) {
        if (value instanceof Integer) {
            return IPredicateMock.expression(value, ILiteralIntegerExpression.class);
        }
        if (value instanceof Long) {
            return IPredicateMock.expression(value, ILiteralLongExpression.class);
        }
        if (value instanceof Float) {
            return IPredicateMock.expression(value, ILiteralFloatExpression.class);
        }
        if (value instanceof Double) {
            return IPredicateMock.expression(value, ILiteralDoubleExpression.class);
        }
        if (value instanceof Boolean) {
            return IPredicateMock.expression(value, ILiteralBooleanExpression.class);
        }
        if (value == null) {
            return IPredicateMock.expression(value, ILiteralNullExpression.class);
        }
        if (value instanceof String || value instanceof UTF8String) {
            return IPredicateMock.expression(value, ILiteralStringExpression.class);
        }
        return IPredicateMock.expression(value, IExpression.class);
    }

    public static <T extends IExpression> T expression(Object value, Class<T> clazz) {
        IExpression mock = (IExpression)Mockito.mock(clazz);
        ValueVector vector = value == null ? ValueVector.literalNull((ResolvedType)ResolvedType.of((Column.Type)Column.Type.Any), (int)1) : ValueVector.literalAny((int)1, (Object)value);
        Mockito.when((Object)mock.accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)mock.eval((IExecutionContext)ArgumentMatchers.any(IExecutionContext.class))).thenReturn((Object)vector);
        Mockito.when((Object)mock.eval((TupleVector)ArgumentMatchers.any(TupleVector.class), (IExecutionContext)ArgumentMatchers.any(IExecutionContext.class))).thenReturn((Object)vector);
        return (T)mock;
    }

    public static IExpression column(QualifiedName column, Object value) {
        IColumnExpression expression = (IColumnExpression)Mockito.mock(IColumnExpression.class);
        ValueVector vector = value == null ? ValueVector.literalNull((ResolvedType)ResolvedType.of((Column.Type)Column.Type.Any), (int)1) : ValueVector.literalAny((int)1, (Object)value);
        Mockito.when((Object)expression.getQualifiedColumn()).thenReturn((Object)column);
        ((IColumnExpression)Mockito.doCallRealMethod().when((Object)expression)).accept((IExpressionVisitor)ArgumentMatchers.any(), ArgumentMatchers.any());
        Mockito.when((Object)expression.eval((IExecutionContext)ArgumentMatchers.any(IExecutionContext.class))).thenReturn((Object)vector);
        Mockito.when((Object)expression.eval((TupleVector)ArgumentMatchers.any(TupleVector.class), (IExecutionContext)ArgumentMatchers.any(IExecutionContext.class))).thenReturn((Object)vector);
        return expression;
    }
}

