/*
 * Decompiled with CFR 0.152.
 */
package se.kuseman.payloadbuilder.test;

import org.junit.Assert;
import se.kuseman.payloadbuilder.api.catalog.Column;
import se.kuseman.payloadbuilder.api.catalog.ResolvedType;
import se.kuseman.payloadbuilder.api.execution.ObjectVector;
import se.kuseman.payloadbuilder.api.execution.TupleVector;
import se.kuseman.payloadbuilder.api.execution.UTF8String;
import se.kuseman.payloadbuilder.api.execution.ValueVector;

public class VectorTestUtils
extends Assert {
    public static ValueVector vv(Column.Type type, Object ... values) {
        return VectorTestUtils.vv(ResolvedType.of((Column.Type)type), values);
    }

    public static ValueVector vv(final ResolvedType type, final Object ... values) {
        return new ValueVector(){

            public boolean isNull(int row) {
                return values[row] == null;
            }

            public ResolvedType type() {
                return type;
            }

            public int size() {
                return values.length;
            }

            public Object getAny(int row) {
                return values[row];
            }

            public ValueVector getArray(int row) {
                return (ValueVector)values[row];
            }

            public TupleVector getTable(int row) {
                return (TupleVector)values[row];
            }

            public ObjectVector getObject(int row) {
                return (ObjectVector)values[row];
            }
        };
    }

    public static void assertTupleVectorsEquals(TupleVector expected, TupleVector actual) {
        VectorTestUtils.assertTupleVectorsEquals("", expected, actual);
    }

    public static void assertTupleVectorsEquals(String message, TupleVector expected, TupleVector actual) {
        TupleVector e = expected;
        TupleVector a = actual;
        VectorTestUtils.assertEquals((String)(message + " Schema should equal"), (Object)e.getSchema(), (Object)a.getSchema());
        VectorTestUtils.assertEquals((String)(message + " Row count should equal"), (long)e.getRowCount(), (long)a.getRowCount());
        for (int j = 0; j < e.getSchema().getSize(); ++j) {
            VectorTestUtils.assertVectorsEquals(message + " Column(" + j + ") ", e.getColumn(j), a.getColumn(j));
        }
    }

    public static void assertObjectVectorsEquals(ObjectVector expected, ObjectVector actual) {
        VectorTestUtils.assertObjectVectorsEquals("", expected, actual);
    }

    public static void assertObjectVectorsEquals(String message, ObjectVector expected, ObjectVector actual) {
        ObjectVector e = expected;
        ObjectVector a = actual;
        VectorTestUtils.assertEquals((String)(message + " Schema should equal"), (Object)e.getSchema(), (Object)a.getSchema());
        for (int j = 0; j < e.getSchema().getSize(); ++j) {
            VectorTestUtils.assertValueEquals(message + " column: " + j + " ", e.getValue(j), a.getValue(j), e.getRow(), a.getRow(), true);
        }
    }

    public static void assertVectorsEqualsNulls(ValueVector expected, ValueVector actual) {
        VectorTestUtils.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            VectorTestUtils.assertEquals((String)("Row " + i + " should be null"), (Object)expected.getAny(i), (Object)actual.isNull(i));
        }
    }

    public static void assertVectorsEquals(ValueVector expected, ValueVector actual) {
        VectorTestUtils.assertVectorsEquals("", expected, actual);
    }

    public static void assertVectorsEquals(String message, ValueVector expected, ValueVector actual) {
        VectorTestUtils.assertVectorsEquals(message, expected, actual, false);
    }

    public static void assertVectorsEquals(String message, ValueVector expected, ValueVector actual, boolean performNumberCasts) {
        VectorTestUtils.assertEquals((String)(message + "Types should equal"), (Object)expected.type(), (Object)actual.type());
        VectorTestUtils.assertEquals((String)(message + "Sizes should equal"), (long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            VectorTestUtils.assertValueEquals(message, expected, actual, i, i, performNumberCasts);
        }
    }

    private static void assertValueEquals(String message, ValueVector expected, ValueVector actual, int expectedRow, int actualRow, boolean performNumberCasts) {
        boolean actualIsNull;
        boolean expectedIsNull = expected.isNull(expectedRow);
        if (expectedIsNull != (actualIsNull = actual.isNull(actualRow))) {
            VectorTestUtils.assertEquals((String)((String)message + "Row " + expectedRow + " not equal regarding isNull"), (Object)expectedIsNull, (Object)actualIsNull);
        }
        if (expectedIsNull && actualIsNull) {
            return;
        }
        if (message != null && !((String)message).isEmpty()) {
            message = (String)message + System.lineSeparator();
        }
        switch (expected.type().getType()) {
            case Boolean: {
                VectorTestUtils.assertEquals((String)((String)message + "Row " + expectedRow + " not equal"), (Object)expected.getBoolean(expectedRow), (Object)actual.getBoolean(actualRow));
                break;
            }
            case Double: {
                VectorTestUtils.assertEquals((String)((String)message + "Row (double) " + expectedRow + " not equal (getDouble)"), (double)expected.getDouble(expectedRow), (double)actual.getDouble(actualRow), (double)0.001);
                if (!performNumberCasts) break;
                VectorTestUtils.assertEquals((String)((String)message + "Row (double) " + expectedRow + " not equal (getInt)"), (long)((int)expected.getDouble(expectedRow)), (long)actual.getInt(actualRow));
                VectorTestUtils.assertEquals((String)((String)message + "Row (double) " + expectedRow + " not equal (getLong)"), (long)((long)expected.getDouble(expectedRow)), (long)actual.getLong(actualRow));
                VectorTestUtils.assertEquals((String)((String)message + "Row (double) " + expectedRow + " not equal (getFloat)"), (double)expected.getDouble(expectedRow), (double)actual.getFloat(actualRow), (double)0.001);
                break;
            }
            case Float: {
                VectorTestUtils.assertEquals((String)((String)message + "Row (float) " + expectedRow + " not equal (getFloat)"), (double)expected.getFloat(expectedRow), (double)actual.getFloat(actualRow), (double)0.001);
                if (!performNumberCasts) break;
                VectorTestUtils.assertEquals((String)((String)message + "Row (float) " + expectedRow + " not equal (getInt)"), (long)((int)expected.getFloat(expectedRow)), (long)actual.getInt(actualRow));
                VectorTestUtils.assertEquals((String)((String)message + "Row (float) " + expectedRow + " not equal (getLong)"), (long)((long)expected.getFloat(expectedRow)), (long)actual.getLong(actualRow));
                VectorTestUtils.assertEquals((String)((String)message + "Row (float) " + expectedRow + " not equal (getDouble)"), (double)expected.getFloat(expectedRow), (double)actual.getDouble(actualRow), (double)0.001);
                break;
            }
            case Int: {
                VectorTestUtils.assertEquals((String)((String)message + "Row (int) " + expectedRow + " not equal (getInt)"), (long)expected.getInt(expectedRow), (long)actual.getInt(actualRow));
                if (!performNumberCasts) break;
                VectorTestUtils.assertEquals((String)((String)message + "Row (int) " + expectedRow + " not equal (getLong)"), (long)expected.getInt(expectedRow), (long)((int)actual.getLong(actualRow)));
                VectorTestUtils.assertEquals((String)((String)message + "Row (int) " + expectedRow + " not equal (getFloat)"), (long)expected.getInt(expectedRow), (long)((int)actual.getFloat(actualRow)));
                VectorTestUtils.assertEquals((String)((String)message + "Row (int) " + expectedRow + " not equal (getDouble)"), (long)expected.getInt(expectedRow), (long)((int)actual.getDouble(actualRow)));
                break;
            }
            case Long: {
                VectorTestUtils.assertEquals((String)((String)message + "Row (long) " + expectedRow + " not equal (getLong)"), (long)expected.getLong(expectedRow), (long)actual.getLong(actualRow));
                if (!performNumberCasts) break;
                VectorTestUtils.assertEquals((String)((String)message + "Row (long) " + expectedRow + " not equal (getInt)"), (long)((int)expected.getLong(expectedRow)), (long)actual.getInt(actualRow));
                VectorTestUtils.assertEquals((String)((String)message + "Row (long) " + expectedRow + " not equal (getFloat)"), (long)expected.getLong(expectedRow), (long)((long)actual.getFloat(actualRow)));
                VectorTestUtils.assertEquals((String)((String)message + "Row (long) " + expectedRow + " not equal (getDouble)"), (long)expected.getLong(expectedRow), (long)((long)actual.getDouble(actualRow)));
                break;
            }
            case Decimal: {
                VectorTestUtils.assertEquals((String)((String)message + "Row (decimal) " + expectedRow + " not equal (getDecimal)"), (Object)expected.getDecimal(expectedRow), (Object)actual.getDecimal(actualRow));
                break;
            }
            case String: {
                VectorTestUtils.assertEquals((String)((String)message + "Row " + expectedRow + " not equal"), (Object)expected.getString(expectedRow), (Object)actual.getString(actualRow));
                break;
            }
            case DateTime: {
                VectorTestUtils.assertEquals((String)((String)message + "Row " + expectedRow + " not equal"), (Object)expected.getDateTime(expectedRow), (Object)actual.getDateTime(actualRow));
                break;
            }
            case DateTimeOffset: {
                VectorTestUtils.assertEquals((String)((String)message + "Row " + expectedRow + " not equal"), (Object)expected.getDateTimeOffset(expectedRow), (Object)actual.getDateTimeOffset(actualRow));
                break;
            }
            case Table: {
                VectorTestUtils.assertTupleVectorsEquals("Table of row: " + expectedRow + ": ", expected.getTable(expectedRow), actual.getTable(actualRow));
                break;
            }
            case Array: {
                VectorTestUtils.assertVectorsEquals("Array of row: " + expectedRow + " should equal: ", expected.getArray(expectedRow), actual.getArray(actualRow));
                break;
            }
            case Object: {
                VectorTestUtils.assertObjectVectorsEquals("Object of row: " + expectedRow + " should equal: ", expected.getObject(expectedRow), actual.getObject(actualRow));
                break;
            }
            default: {
                Object exp = expected.getAny(expectedRow);
                Object act = actual.getAny(actualRow);
                if (exp instanceof ValueVector) {
                    VectorTestUtils.assertVectorsEquals("Vector of row: " + expectedRow + " should equal: ", (ValueVector)exp, (ValueVector)act);
                    break;
                }
                if (exp instanceof TupleVector) {
                    VectorTestUtils.assertTupleVectorsEquals("Row: " + expectedRow, (TupleVector)exp, (TupleVector)act);
                    break;
                }
                if (exp instanceof ObjectVector) {
                    VectorTestUtils.assertObjectVectorsEquals("Object of row: " + expectedRow, (ObjectVector)exp, (ObjectVector)act);
                    break;
                }
                if (exp instanceof UTF8String) {
                    exp = ((UTF8String)exp).toString();
                }
                if (act instanceof UTF8String) {
                    act = ((UTF8String)act).toString();
                }
                VectorTestUtils.assertEquals((String)((String)message + "Row " + expectedRow + " not equal"), (Object)exp, (Object)act);
            }
        }
    }
}

