/*
 * Decompiled with CFR 0.152.
 */
package se.l4.jobs.backend.silo;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.l4.commons.id.LongIdGenerator;
import se.l4.commons.id.SimpleLongIdGenerator;
import se.l4.jobs.JobCancelledException;
import se.l4.jobs.backend.silo.StoredJob;
import se.l4.jobs.engine.JobControl;
import se.l4.jobs.engine.JobRetryException;
import se.l4.jobs.engine.JobsBackend;
import se.l4.jobs.engine.QueuedJob;
import se.l4.silo.FetchResult;
import se.l4.silo.engine.Index;
import se.l4.silo.engine.builder.IndexBuilder;
import se.l4.silo.engine.builder.SiloBuilder;
import se.l4.silo.engine.builder.StructuredEntityBuilder;
import se.l4.silo.query.IndexQuery;
import se.l4.silo.structured.ObjectEntity;
import se.l4.silo.structured.StructuredEntity;

public class SiloJobsBackend
implements JobsBackend {
    private static final Logger log = LoggerFactory.getLogger(SiloJobsBackend.class);
    private final ObjectEntity<StoredJob> entity;
    private final LongIdGenerator ids = new SimpleLongIdGenerator();
    private final ReentrantLock timestampLock;
    private JobControl control;
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> future;
    private long closestTimestamp;

    public SiloJobsBackend(StructuredEntity entity) {
        this.entity = entity.asObject(StoredJob.class, o -> o.getId());
        this.timestampLock = new ReentrantLock();
    }

    public long nextId() {
        return this.ids.next();
    }

    public void start(JobControl control) {
        this.timestampLock.lock();
        try {
            this.control = control;
            this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("jobs-silo-queuer-%d").setDaemon(true).build());
        }
        finally {
            this.timestampLock.unlock();
        }
        try (FetchResult fr = (FetchResult)((IndexQuery)this.entity.query("sortedByTime", IndexQuery.type())).field("timestamp").sort(true).run();){
            Optional first = fr.first();
            if (!first.isPresent()) {
                this.scheduleRun(System.currentTimeMillis() + 300000L, false);
                return;
            }
            StoredJob job = (StoredJob)first.get();
            this.scheduleRun(job.getScheduledTime(), true);
        }
    }

    public void stop() {
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void accept(QueuedJob<?, ?> job) {
        StoredJob storedJob = new StoredJob(job.getId(), job.getKnownId().orElse(null), job.getData(), job.getFirstScheduled(), job.getScheduledTime(), job.getSchedule().orElse(null), job.getAttempt());
        this.entity.store((Object)storedJob);
        this.scheduleRun(job.getScheduledTime(), false);
    }

    public void cancel(long id) {
        this.entity.deleteViaId((Object)id);
        this.control.failJob(id, (Throwable)new JobCancelledException("Job was cancelled"));
    }

    public Optional<QueuedJob<?, ?>> getViaId(String id) {
        try (FetchResult fr = (FetchResult)((IndexQuery)this.entity.query("viaKnownId", IndexQuery.type())).field("knownId").isEqualTo((Object)id).run();){
            Optional<QueuedJob<?, ?>> optional = Optional.ofNullable(fr.first().orElse(null));
            return optional;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRun(long timestamp, boolean ignoreClosest) {
        this.timestampLock.lock();
        try {
            long now = System.currentTimeMillis();
            long delay = Math.max(0L, timestamp - now);
            timestamp = now + delay;
            if (this.future != null) {
                if (!ignoreClosest && timestamp > this.closestTimestamp) {
                    return;
                }
                this.future.cancel(false);
            }
            log.debug("Scheduling running of jobs in {} ms", (Object)delay);
            this.closestTimestamp = now + delay;
            this.future = this.executor.schedule(() -> this.runJobs(this.control), delay, TimeUnit.MILLISECONDS);
        }
        finally {
            this.timestampLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runJobs(JobControl control) {
        this.timestampLock.lock();
        try {
            long now = System.currentTimeMillis();
            if (this.closestTimestamp <= now) {
                this.future = null;
                this.closestTimestamp = now;
            }
        }
        finally {
            this.timestampLock.unlock();
        }
        block11: while (true) {
            FetchResult fr = (FetchResult)((IndexQuery)((IndexQuery)this.entity.query("sortedByTime", IndexQuery.type())).field("timestamp").sort(true).limit(10L)).run();
            try {
                log.debug("Checking {} jobs if they should be run", (Object)fr.getSize());
                if (fr.isEmpty()) break;
                Iterator iterator = fr.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block11;
                    StoredJob job = (StoredJob)iterator.next();
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    if (job.getScheduledTime() > System.currentTimeMillis()) {
                        this.scheduleRun(job.getScheduledTime(), true);
                        return;
                    }
                    this.entity.deleteViaId((Object)job.getId());
                    long id = job.getId();
                    control.runJob((QueuedJob)job).whenComplete((value, e) -> {
                        if (e == null) {
                            control.completeJob(id, value);
                        } else if (!(e instanceof JobRetryException)) {
                            control.failJob(id, e);
                        }
                    });
                }
            }
            finally {
                if (fr == null) continue;
                fr.close();
                continue;
            }
            break;
        }
        this.scheduleRun(System.currentTimeMillis() + 300000L, false);
    }

    public static SiloBuilder defineJobEntity(SiloBuilder builder, String name) {
        StructuredEntityBuilder structuredBuilder = builder.addEntity(name).asStructured();
        SiloJobsBackend.defineJobEntity(structuredBuilder);
        return (SiloBuilder)structuredBuilder.done();
    }

    public static <T> StructuredEntityBuilder<T> defineJobEntity(StructuredEntityBuilder<T> builder) {
        return (StructuredEntityBuilder)((IndexBuilder)((StructuredEntityBuilder)((IndexBuilder)((StructuredEntityBuilder)((StructuredEntityBuilder)builder.defineField("timestamp", "long")).defineField("knownId", "string")).add("sortedByTime", Index::queryEngine)).addSortField("timestamp").done()).add("viaKnownId", Index::queryEngine)).addField("knownId").done();
    }
}

