/*
 * Decompiled with CFR 0.152.
 */
package se.l4.jobs.backend.silo;

import java.util.Optional;
import se.l4.commons.serialization.AllowAny;
import se.l4.commons.serialization.Expose;
import se.l4.commons.serialization.ReflectionSerializer;
import se.l4.commons.serialization.Use;
import se.l4.jobs.JobData;
import se.l4.jobs.Schedule;
import se.l4.jobs.engine.QueuedJob;

@Use(value=ReflectionSerializer.class)
public class StoredJob
implements QueuedJob<JobData<Object>, Object> {
    @Expose
    private final long id;
    @Expose
    private final String knownId;
    @Expose
    @AllowAny
    private final Object data;
    @Expose
    private final long firstScheduledTime;
    @Expose
    private final long scheduledTime;
    @Expose
    @AllowAny
    private final Schedule schedule;
    @Expose
    private final int attempt;

    public StoredJob(@Expose(value="id") long id, @Expose(value="knownId") String knownId, @Expose(value="data") Object data, @Expose(value="firstScheduledTime") long firstScheduledTime, @Expose(value="scheduledTime") long scheduledTime, @Expose(value="schedule") Schedule schedule, @Expose(value="attempt") int attempt) {
        this.id = id;
        this.knownId = knownId;
        this.data = data;
        this.firstScheduledTime = firstScheduledTime;
        this.scheduledTime = scheduledTime;
        this.schedule = schedule;
        this.attempt = attempt;
    }

    public long getId() {
        return this.id;
    }

    public Optional<String> getKnownId() {
        return Optional.ofNullable(this.knownId);
    }

    public JobData<Object> getData() {
        return (JobData)this.data;
    }

    public long getFirstScheduled() {
        return this.firstScheduledTime;
    }

    public long getScheduledTime() {
        return this.scheduledTime;
    }

    public Optional<Schedule> getSchedule() {
        return Optional.ofNullable(this.schedule);
    }

    public int getAttempt() {
        return this.attempt;
    }
}

