/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.common.validation;

import java.time.Duration;
import java.time.Instant;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.saml2.assertion.SAML20AssertionValidator;
import se.litsec.opensaml.common.validation.ObjectValidator;

public abstract class AbstractObjectValidator<T extends XMLObject>
implements ObjectValidator<T> {
    public static final Duration DEFAULT_MAX_AGE_RECEIVED_MESSAGE = Duration.ofMinutes(3L);

    public static boolean isStrictValidation(ValidationContext context) {
        Boolean strict = (Boolean)context.getStaticParameters().get("saml2.StrictValidation");
        return strict != null ? strict : false;
    }

    public static Duration getAllowedClockSkew(ValidationContext context) {
        Object object = context.getStaticParameters().get("saml2.ClockSkew");
        if (object != null) {
            if (Duration.class.isInstance(object)) {
                return (Duration)Duration.class.cast(object);
            }
            if (Long.class.isInstance(object)) {
                DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)"saml2.ClockSkew", null, (String)Duration.class.getName());
                return Duration.ofMillis((Long)Long.class.cast(object));
            }
        }
        return SAML20AssertionValidator.DEFAULT_CLOCK_SKEW;
    }

    public static Duration getMaxAgeReceivedMessage(ValidationContext context) {
        Object object = context.getStaticParameters().get("saml2.MaxAgeReceivedMessage");
        if (object != null) {
            if (Duration.class.isInstance(object)) {
                return (Duration)Duration.class.cast(object);
            }
            if (Long.class.isInstance(object)) {
                DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)"saml2.MaxAgeReceivedMessage", null, (String)Duration.class.getName());
                return Duration.ofMillis((Long)Long.class.cast(object));
            }
        }
        return DEFAULT_MAX_AGE_RECEIVED_MESSAGE;
    }

    public static Instant getReceiveInstant(ValidationContext context) {
        Object object = context.getStaticParameters().get("saml2.ReceiveInstant");
        if (object != null) {
            if (Instant.class.isInstance(object)) {
                return (Instant)Instant.class.cast(object);
            }
            if (Long.class.isInstance(object)) {
                DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)"saml2.ReceiveInstant", null, (String)Duration.class.getName());
                return Instant.ofEpochMilli((Long)Long.class.cast(object));
            }
        }
        return Instant.now();
    }
}

