/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.common.validation;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.saml.common.assertion.ValidationContext;
import se.litsec.opensaml.common.validation.ValidationParametersBuilder;

public abstract class AbstractValidationParametersBuilder<T extends AbstractValidationParametersBuilder<T>>
implements ValidationParametersBuilder {
    private Map<String, Object> staticParameters = new HashMap<String, Object>();
    private Map<String, Object> dynamicParameters = new HashMap<String, Object>();

    @Override
    public ValidationContext build() {
        ValidationContext context = new ValidationContext(this.staticParameters);
        context.getDynamicParameters().putAll(this.dynamicParameters);
        return context;
    }

    public T staticParameter(String name, Object value) {
        this.addStaticParameter(name, value);
        return this.getThis();
    }

    public T dynamicParameter(String name, Object value) {
        this.addStaticParameter(name, value);
        return this.getThis();
    }

    public T strictValidation(boolean flag) {
        this.addStaticParameter("saml2.StrictValidation", flag);
        return this.getThis();
    }

    public T allowedClockSkew(Duration skew) {
        this.addStaticParameter("saml2.ClockSkew", skew);
        return this.getThis();
    }

    public T allowedClockSkew(long millis) {
        return this.allowedClockSkew(Duration.ofMillis(millis));
    }

    public T maxAgeReceivedMessage(Duration maxAge) {
        this.addStaticParameter("saml2.MaxAgeReceivedMessage", maxAge);
        return this.getThis();
    }

    public T maxAgeReceivedMessage(long millis) {
        return this.maxAgeReceivedMessage(Duration.ofMillis(millis));
    }

    public T receiveInstant(Instant instant) {
        this.addStaticParameter("saml2.ReceiveInstant", instant);
        return this.getThis();
    }

    public T receiveInstant(long instant) {
        return this.receiveInstant(Instant.ofEpochMilli(instant));
    }

    public T signatureRequired(boolean required) {
        this.addStaticParameter("saml2.SignatureRequired", required);
        return this.getThis();
    }

    public T signatureValidationCriteriaSet(CriteriaSet criteriaSet) {
        if (criteriaSet != null) {
            this.addStaticParameter("saml2.SignatureValidationCriteriaSet", criteriaSet);
        }
        return this.getThis();
    }

    protected abstract T getThis();

    public final void addStaticParameter(String name, Object value) {
        if (name != null) {
            this.staticParameters.put(name, value);
        }
    }

    public final void addStaticParameterIfMissing(String name, Object value) {
        if (name != null && !this.staticParameters.containsKey(name)) {
            this.addStaticParameter(name, value);
        }
    }

    public final void addStaticParameters(Map<String, Object> pars) {
        if (pars != null) {
            this.staticParameters.putAll(pars);
        }
    }

    public final void addDynamicParameter(String name, Object value) {
        if (name != null) {
            this.staticParameters.put(name, value);
        }
    }

    public final void addDynamicParameters(Map<String, Object> pars) {
        if (pars != null) {
            this.dynamicParameters.putAll(pars);
        }
    }
}

