/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.core;

import java.io.InputStream;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLRuntimeException;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.SAMLObject;
import se.litsec.opensaml.core.SAMLObjectBuilder;
import se.litsec.opensaml.utils.ObjectUtils;

public abstract class AbstractSAMLObjectBuilder<T extends SAMLObject>
implements SAMLObjectBuilder<T> {
    private T object;

    public AbstractSAMLObjectBuilder() {
        this.object = (SAMLObject)this.getObjectType().cast(XMLObjectSupport.buildXMLObject((QName)this.getDefaultElementName()));
    }

    public AbstractSAMLObjectBuilder(T template) throws MarshallingException, UnmarshallingException {
        this.object = (SAMLObject)XMLObjectSupport.cloneXMLObject(template);
    }

    public AbstractSAMLObjectBuilder(InputStream resource) throws XMLParserException, UnmarshallingException {
        this.object = (SAMLObject)ObjectUtils.unmarshall(resource, this.getObjectType());
    }

    @Override
    public T build() {
        return this.object();
    }

    protected abstract Class<T> getObjectType();

    public final T object() {
        return this.object;
    }

    protected QName getDefaultElementName() {
        try {
            return (QName)this.getObjectType().getDeclaredField("DEFAULT_ELEMENT_NAME").get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new XMLRuntimeException(e);
        }
    }
}

