/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.attribute;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLRuntimeException;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeValue;
import se.litsec.opensaml.core.AbstractSAMLObjectBuilder;

public class AttributeBuilder
extends AbstractSAMLObjectBuilder<Attribute> {
    public static final String DEFAULT_NAME_FORMAT = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";

    public AttributeBuilder(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        ((Attribute)this.object()).setName(name);
    }

    public static AttributeBuilder builder(String name) {
        return new AttributeBuilder(name);
    }

    public AttributeBuilder(Attribute template) throws MarshallingException, UnmarshallingException {
        super(template);
    }

    public static AttributeBuilder builder(Attribute attribute) throws MarshallingException, UnmarshallingException {
        return new AttributeBuilder(attribute);
    }

    public AttributeBuilder(InputStream resource) throws XMLParserException, UnmarshallingException {
        super(resource);
    }

    public static AttributeBuilder builder(InputStream resource) throws XMLParserException, UnmarshallingException {
        return new AttributeBuilder(resource);
    }

    @Override
    public Attribute build() {
        if (((Attribute)this.object()).getName() == null) {
            throw new RuntimeException("Attribute can not be built without a name");
        }
        if (((Attribute)this.object()).getNameFormat() == null) {
            ((Attribute)this.object()).setNameFormat(DEFAULT_NAME_FORMAT);
        }
        return (Attribute)super.build();
    }

    public AttributeBuilder name(String name) {
        ((Attribute)this.object()).setName(name);
        return this;
    }

    public AttributeBuilder friendlyName(String friendlyName) {
        ((Attribute)this.object()).setFriendlyName(friendlyName);
        return this;
    }

    public AttributeBuilder nameFormat(String nameFormat) {
        ((Attribute)this.object()).setNameFormat(nameFormat);
        return this;
    }

    public AttributeBuilder value(String ... values) {
        return this.value((XMLObject)(values != null ? Arrays.asList(values) : null));
    }

    public AttributeBuilder value(List<String> values) {
        if (values == null) {
            ((Attribute)this.object()).getAttributeValues().clear();
            return this;
        }
        for (String s : values) {
            XSString sv = AttributeBuilder.createValueObject(XSString.TYPE_NAME, XSString.class);
            sv.setValue(s);
            ((Attribute)this.object()).getAttributeValues().add(sv);
        }
        return this;
    }

    public <T extends XMLObject> AttributeBuilder value(T value) {
        ((Attribute)this.object()).getAttributeValues().add(value);
        return this;
    }

    public static <T extends XMLObject> T createValueObject(Class<T> clazz) {
        try {
            QName schemaType = (QName)clazz.getDeclaredField("TYPE_NAME").get(null);
            return AttributeBuilder.createValueObject(schemaType, clazz);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new XMLRuntimeException(e);
        }
    }

    public static <T extends XMLObject> T createValueObject(QName schemaType, Class<T> clazz) {
        return (T)((XMLObject)clazz.cast(XMLObjectSupport.getBuilder((QName)schemaType).buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, schemaType)));
    }

    @Override
    protected Class<Attribute> getObjectType() {
        return Attribute.class;
    }
}

