/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.attribute;

import java.util.List;
import java.util.stream.Collectors;
import se.litsec.opensaml.saml2.attribute.AttributeRepository;
import se.litsec.opensaml.saml2.attribute.AttributeTemplate;

public class AttributeRepositoryImpl
implements AttributeRepository {
    private List<AttributeTemplate> attributes;

    public AttributeRepositoryImpl(List<AttributeTemplate> attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes must not be null");
        }
        this.attributes = attributes;
    }

    @Override
    public List<String> getAttributeNames() {
        return this.attributes.stream().map(AttributeTemplate::getName).collect(Collectors.toList());
    }

    @Override
    public AttributeTemplate getByName(String name) {
        return this.attributes.stream().filter(a -> name.equals(a.getName())).findFirst().orElse(null);
    }

    @Override
    public AttributeTemplate getByFriendlyName(String friendlyName) {
        return this.attributes.stream().filter(a -> friendlyName.equals(a.getFriendlyName())).findFirst().orElse(null);
    }
}

