/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.attribute;

import se.litsec.opensaml.saml2.attribute.AttributeBuilder;

public class AttributeTemplate {
    private String name;
    private String friendlyName;
    private String nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";

    public AttributeTemplate(String name, String friendlyName) {
        this(name, friendlyName, "urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
    }

    public AttributeTemplate(String name, String friendlyName, String nameFormat) {
        if (name == null) {
            throw new NullPointerException("'name' must not be null");
        }
        this.name = name;
        this.friendlyName = friendlyName;
        this.nameFormat = nameFormat != null ? nameFormat : "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";
    }

    public String getName() {
        return this.name;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getNameFormat() {
        return this.nameFormat;
    }

    public AttributeBuilder createBuilder() {
        AttributeBuilder builder = new AttributeBuilder(this.name);
        return builder.friendlyName(this.friendlyName).nameFormat(this.nameFormat);
    }
}

