/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.common.assertion;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.saml2.common.response.AbstractResponseValidationParametersBuilder;

public abstract class AbstractAssertionValidationParametersBuilder<T extends AbstractAssertionValidationParametersBuilder<T>>
extends AbstractResponseValidationParametersBuilder<T> {
    private final Logger log = LoggerFactory.getLogger(AbstractAssertionValidationParametersBuilder.class);

    @Override
    public ValidationContext build() {
        this.addStaticParameterIfMissing("saml2.SubjectConfirmation.CheckAddress", Boolean.FALSE);
        this.addStaticParameterIfMissing("saml2.Statement.Authn.SubjectLocality.CheckAddress", Boolean.FALSE);
        return super.build();
    }

    public T responseIssueInstant(Instant instant) {
        return (T)((AbstractAssertionValidationParametersBuilder)this.staticParameter("saml2.ResponseIssueInstant", instant));
    }

    public T responseIssueInstant(long instant) {
        return this.responseIssueInstant(Instant.ofEpochMilli(instant));
    }

    public T validRecipients(String ... recipients) {
        if (recipients != null) {
            HashSet<String> set = new HashSet<String>();
            for (String r : recipients) {
                set.add(r);
            }
            this.staticParameter("saml2.SubjectConfirmation.RecipientRequired", Boolean.TRUE);
            return (T)((AbstractAssertionValidationParametersBuilder)this.staticParameter("saml2.SubjectConfirmation.ValidRecipients", set));
        }
        return (T)((AbstractAssertionValidationParametersBuilder)this.getThis());
    }

    public T validAddresses(InetAddress ... addresses) {
        if (addresses != null) {
            HashSet<InetAddress> set = new HashSet<InetAddress>();
            for (InetAddress a : addresses) {
                set.add(a);
            }
            if (!set.isEmpty()) {
                this.staticParameter("saml2.SubjectConfirmation.ValidAddresses", set);
                this.staticParameter("saml2.Statement.Authn.SubjectLocality.ValidAddresses", set);
            }
        }
        return (T)((AbstractAssertionValidationParametersBuilder)this.getThis());
    }

    public T validAddresses(String ... addresses) {
        if (addresses == null) {
            return (T)((AbstractAssertionValidationParametersBuilder)this.getThis());
        }
        ArrayList<InetAddress> _addresses = new ArrayList<InetAddress>();
        for (String a : addresses) {
            try {
                _addresses.add(InetAddress.getByName(a));
            }
            catch (UnknownHostException e) {
                this.log.error("Invalid IP address - " + a, (Throwable)e);
                return (T)((AbstractAssertionValidationParametersBuilder)this.getThis());
            }
        }
        return this.validAddresses(_addresses.toArray(new InetAddress[0]));
    }

    public T subjectConfirmationCheckAddess(boolean flag) {
        return (T)((AbstractAssertionValidationParametersBuilder)this.staticParameter("saml2.SubjectConfirmation.CheckAddress", flag));
    }

    public T subjectLocalityCheckAddress(boolean flag) {
        return (T)((AbstractAssertionValidationParametersBuilder)this.staticParameter("saml2.Statement.Authn.SubjectLocality.CheckAddress", flag));
    }

    public T validAudiences(String ... audiences) {
        if (audiences != null) {
            HashSet<String> set = new HashSet<String>();
            for (String a : audiences) {
                set.add(a);
            }
            return (T)((AbstractAssertionValidationParametersBuilder)this.staticParameter("saml2.Conditions.ValidAudiences", set));
        }
        return (T)((AbstractAssertionValidationParametersBuilder)this.getThis());
    }

    public T authnRequestForceAuthn(Boolean forceAuthn) {
        return (T)((AbstractAssertionValidationParametersBuilder)this.staticParameter("saml2.AuthnRequestForceAuthn", forceAuthn));
    }

    public T authnRequestIssueInstant(Instant issueInstant) {
        return (T)((AbstractAssertionValidationParametersBuilder)this.staticParameter("saml2.AuthnRequestIssueInstant", issueInstant));
    }

    public T authnRequestIssueInstant(long issueInstant) {
        return this.authnRequestIssueInstant(Instant.ofEpochMilli(issueInstant));
    }

    public T maxAcceptedSsoSessionTime(long duration) {
        return this.maxAcceptedSsoSessionTime(Duration.ofMillis(duration));
    }

    public T maxAcceptedSsoSessionTime(Duration duration) {
        return (T)((AbstractAssertionValidationParametersBuilder)this.staticParameter("saml2.MaxAcceptedSsoSessionTime", duration));
    }

    public T inResponseTo(String id) {
        this.addStaticParameter("saml2.SubjectConfirmation.InResponseToRequired", Boolean.TRUE);
        return (T)((AbstractAssertionValidationParametersBuilder)this.staticParameter("saml2.SubjectConfirmation.ValidInResponseTo", id));
    }
}

