/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.common.assertion;

import java.time.Duration;
import java.time.Instant;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.common.validation.AbstractObjectValidator;
import se.litsec.opensaml.common.validation.ValidationSupport;

public class AuthnStatementValidator
extends org.opensaml.saml.saml2.assertion.impl.AuthnStatementValidator {
    public static final String AUTHN_REQUEST_FORCE_AUTHN = "saml2.AuthnRequestForceAuthn";
    public static final String AUTHN_REQUEST_ISSUE_INSTANT = "saml2.AuthnRequestIssueInstant";
    public static final String MAX_ACCEPTED_SSO_SESSION_TIME = "saml2.MaxAcceptedSsoSessionTime";
    private final Logger log = LoggerFactory.getLogger(AuthnStatementValidator.class);

    public final ValidationResult validate(Statement statement, Assertion assertion, ValidationContext context) throws AssertionValidationException {
        if (statement instanceof AuthnStatement) {
            return this.validate((AuthnStatement)statement, assertion, context);
        }
        throw new AssertionValidationException("Illegal call - statement is of type " + statement.getClass().getSimpleName());
    }

    protected ValidationResult validate(AuthnStatement statement, Assertion assertion, ValidationContext context) throws AssertionValidationException {
        try {
            ValidationSupport.check(this.validateAuthnInstant(statement, assertion, context));
            ValidationSupport.check(this.validateSessionIndex(statement, assertion, context));
            ValidationSupport.check(this.validateSessionNotOnOrAfter(statement, assertion, context));
            ValidationSupport.check(this.validateSubjectLocality(statement, assertion, context));
            ValidationSupport.check(this.validateAuthnContext(statement, assertion, context));
        }
        catch (AssertionValidationException e) {
            this.log.warn("Error during determining AuthnStatement validity", (Throwable)e);
            context.setValidationFailureMessage("AuthnStatement validation failure - " + e.getMessage());
            return ValidationResult.INDETERMINATE;
        }
        catch (ValidationSupport.ValidationResultException e) {
            return e.getResult();
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateAuthnInstant(AuthnStatement statement, Assertion assertion, ValidationContext context) {
        if (statement.getAuthnInstant() == null) {
            context.setValidationFailureMessage("AuthnInstant of Assertion/@AuthnStatement is missing");
            return ValidationResult.INVALID;
        }
        if (statement.getAuthnInstant().isAfter(assertion.getIssueInstant())) {
            context.setValidationFailureMessage("AuthnInstant is after assertion issue instant - invalid");
            return ValidationResult.INVALID;
        }
        return this.validateSsoAndSession(statement.getAuthnInstant(), statement, assertion, context);
    }

    protected ValidationResult validateSsoAndSession(Instant authnInstant, AuthnStatement statement, Assertion assertion, ValidationContext context) {
        Duration maxTimeSinceAuthn;
        Boolean forceAuthn = AuthnStatementValidator.getForceAuthnFlag(context);
        Instant authnRequestIssueInstant = AuthnStatementValidator.getAuthnRequestIssueInstant(context);
        Duration clockSkew = AbstractObjectValidator.getAllowedClockSkew(context);
        if (forceAuthn != null && forceAuthn.booleanValue()) {
            if (authnRequestIssueInstant != null) {
                if (authnInstant.plus(clockSkew).isBefore(authnRequestIssueInstant)) {
                    String msg = String.format("Invalid Assertion. Force authentication was requested, but authentication instant (%s) is before the issuance time of the authentication request (%s)", authnInstant, authnRequestIssueInstant);
                    context.setValidationFailureMessage(msg);
                    return ValidationResult.INVALID;
                }
            } else {
                this.log.warn("%s (or %s) not suppplied - cannot check SSO", (Object)AUTHN_REQUEST_ISSUE_INSTANT, (Object)"saml2.AuthnRequest");
            }
        } else {
            Duration maxSessionTime = AuthnStatementValidator.getMaxAcceptedSsoSessionTime(context);
            if (maxSessionTime != null && authnInstant.plus(maxSessionTime).isBefore(AbstractObjectValidator.getReceiveInstant(context))) {
                String msg = String.format("Session length violation. Authentication instant (%s) is too far back in time to be accepted by SP SSO policy", authnInstant);
                context.setValidationFailureMessage(msg);
                return ValidationResult.INVALID;
            }
        }
        if ((maxTimeSinceAuthn = (Duration)context.getStaticParameters().get("saml2.Statement.Authn.MaxTimeSinceAuthn")) != null) {
            Instant latestValid = authnInstant.plus(maxTimeSinceAuthn).plus(clockSkew);
            Instant receiveInstant = AbstractObjectValidator.getReceiveInstant(context);
            if (receiveInstant.isAfter(latestValid)) {
                String msg = String.format("AuthnStatement/@AuthnInstant '%s' eval failed, now is after latest valid (including skew) '%s'", authnInstant, latestValid);
                context.setValidationFailureMessage(msg);
                return ValidationResult.INVALID;
            }
        }
        return ValidationResult.VALID;
    }

    protected static Duration getMaxAcceptedSsoSessionTime(ValidationContext context) {
        Object object = context.getStaticParameters().get(MAX_ACCEPTED_SSO_SESSION_TIME);
        if (object != null) {
            if (Duration.class.isInstance(object)) {
                return (Duration)Duration.class.cast(object);
            }
            if (Long.class.isInstance(object)) {
                DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)AUTHN_REQUEST_ISSUE_INSTANT, null, (String)Duration.class.getName());
                return Duration.ofMillis((Long)Long.class.cast(object));
            }
        }
        return null;
    }

    protected static Boolean getForceAuthnFlag(ValidationContext context) {
        AuthnRequest authnRequest;
        Boolean forceAuthn = (Boolean)context.getStaticParameters().get(AUTHN_REQUEST_FORCE_AUTHN);
        if (forceAuthn == null && (authnRequest = (AuthnRequest)context.getStaticParameters().get("saml2.AuthnRequest")) != null) {
            forceAuthn = authnRequest.isForceAuthn();
        }
        return forceAuthn;
    }

    protected static Instant getAuthnRequestIssueInstant(ValidationContext context) {
        AuthnRequest authnRequest;
        Object object = context.getStaticParameters().get(AUTHN_REQUEST_ISSUE_INSTANT);
        if (object != null) {
            if (Instant.class.isInstance(object)) {
                return (Instant)Instant.class.cast(object);
            }
            if (Long.class.isInstance(object)) {
                DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)AUTHN_REQUEST_ISSUE_INSTANT, null, (String)Instant.class.getName());
                return Instant.ofEpochMilli((Long)Long.class.cast(object));
            }
        }
        if ((authnRequest = (AuthnRequest)context.getStaticParameters().get("saml2.AuthnRequest")) != null) {
            return authnRequest.getIssueInstant();
        }
        return null;
    }

    protected ValidationResult validateSessionIndex(AuthnStatement statement, Assertion assertion, ValidationContext context) {
        return ValidationResult.VALID;
    }

    protected ValidationResult validateSessionNotOnOrAfter(AuthnStatement statement, Assertion assertion, ValidationContext context) {
        return ValidationResult.VALID;
    }

    protected ValidationResult validateAuthnContext(AuthnStatement statement, Assertion assertion, ValidationContext context) {
        if (statement.getAuthnContext() == null) {
            context.setValidationFailureMessage("AuthnContext element is missing in Assertion/@AuthnStatement");
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }
}

