/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.common.response;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.saml2.common.response.MessageReplayChecker;
import se.litsec.opensaml.saml2.common.response.MessageReplayException;

public class InMemoryReplayChecker
implements MessageReplayChecker {
    private static final int MAX_SIZE = 1000;
    private final Logger log = LoggerFactory.getLogger(InMemoryReplayChecker.class);
    private long replayCacheExpiration = 300000L;
    private Map<String, Long> cache = new ConcurrentHashMap<String, Long>();

    @Override
    public synchronized void checkReplay(String id) throws MessageReplayException {
        Long e = this.cache.get(id);
        if (e == null) {
            this.cache.put(id, this.replayCacheExpiration + System.currentTimeMillis());
        } else if (System.currentTimeMillis() > e) {
            this.cache.remove(id);
            String msg = String.format("Replay check of ID '%s' failed", id);
            this.log.warn(msg);
            throw new MessageReplayException(msg);
        }
        this.log.debug("Message replay check of ID '{}' succeeded", (Object)id);
        if (this.cache.size() > 1000) {
            long now = System.currentTimeMillis();
            this.cache.entrySet().removeIf(entry -> now > (Long)entry.getValue());
        }
    }

    @Override
    public void checkReplay(SAMLObject object) throws MessageReplayException, IllegalArgumentException {
        String id = null;
        if (object instanceof Response) {
            id = ((Response)object).getID();
        } else if (object instanceof Assertion) {
            id = ((Assertion)object).getID();
        }
        if (id == null) {
            throw new IllegalArgumentException("Unsupported object type");
        }
        this.checkReplay(id);
    }

    public void setReplayCacheExpiration(long replayCacheExpiration) {
        if (replayCacheExpiration < 0L) {
            throw new IllegalArgumentException("replayCacheExpiration must be greater than 0");
        }
        this.replayCacheExpiration = replayCacheExpiration;
    }
}

