/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.common.response;

import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Subject;
import se.litsec.opensaml.saml2.common.response.ResponseProcessingResult;

public class ResponseProcessingResultImpl
implements ResponseProcessingResult {
    private final Assertion assertion;

    public ResponseProcessingResultImpl(Assertion assertion) {
        this.assertion = assertion;
    }

    @Override
    public Assertion getAssertion() {
        return this.assertion;
    }

    @Override
    public List<Attribute> getAttributes() {
        try {
            return Collections.unmodifiableList(((AttributeStatement)this.assertion.getAttributeStatements().get(0)).getAttributes());
        }
        catch (NullPointerException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public String getAuthnContextClassUri() {
        try {
            return ((AuthnStatement)this.assertion.getAuthnStatements().get(0)).getAuthnContext().getAuthnContextClassRef().getURI();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public Instant getAuthnInstant() {
        Instant authnInstant = ((AuthnStatement)this.assertion.getAuthnStatements().get(0)).getAuthnInstant();
        if (authnInstant.isAfter(Instant.now())) {
            return Instant.now();
        }
        return authnInstant;
    }

    @Override
    public String getIssuer() {
        return Optional.ofNullable(this.assertion.getIssuer()).map(XSString::getValue).orElse(null);
    }

    @Override
    public NameID getSubjectNameID() {
        return Optional.ofNullable(this.assertion.getSubject()).map(Subject::getNameID).orElse(null);
    }
}

