/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.common.response;

import java.time.Duration;
import java.util.Optional;

public class ResponseValidationSettings {
    public static final Duration DEFAULT_ALLOWED_CLOCK_SKEW = Duration.ofSeconds(30L);
    public static final Duration DEFAULT_MAX_AGE_RESPONSE = Duration.ofMinutes(3L);
    public static final Duration DEFAULT_MAX_SESSION_AGE = Duration.ofHours(1L);
    private Duration allowedClockSkew;
    private Duration maxAgeResponse;
    private Duration maxSessionAge;
    private boolean strictValidation = false;
    private boolean requireSignedAssertions = false;

    public Duration getAllowedClockSkew() {
        return Optional.ofNullable(this.allowedClockSkew).orElse(DEFAULT_ALLOWED_CLOCK_SKEW);
    }

    public void setAllowedClockSkew(Duration allowedClockSkew) {
        this.allowedClockSkew = allowedClockSkew;
    }

    public Duration getMaxAgeResponse() {
        return Optional.ofNullable(this.maxAgeResponse).orElse(DEFAULT_MAX_AGE_RESPONSE);
    }

    public void setMaxAgeResponse(Duration maxAgeResponse) {
        this.maxAgeResponse = maxAgeResponse;
    }

    public Duration getMaxSessionAge() {
        return Optional.ofNullable(this.maxSessionAge).orElse(DEFAULT_MAX_SESSION_AGE);
    }

    public void setMaxSessionAge(Duration maxSessionAge) {
        this.maxSessionAge = maxSessionAge;
    }

    public boolean isStrictValidation() {
        return this.strictValidation;
    }

    public void setStrictValidation(boolean strictValidation) {
        this.strictValidation = strictValidation;
    }

    public boolean isRequireSignedAssertions() {
        return this.requireSignedAssertions;
    }

    public void setRequireSignedAssertions(boolean requireSignedAssertions) {
        this.requireSignedAssertions = requireSignedAssertions;
    }

    public String toString() {
        return String.format("allowedClockSkew=%s, maxAgeResponse=%s, maxSessionAge=%s, strictValidation=%s, requireSignedAssertions=%s", this.allowedClockSkew, this.maxAgeResponse, this.maxSessionAge, this.strictValidation, this.requireSignedAssertions);
    }
}

