/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata;

import java.time.Duration;
import java.time.Instant;
import net.shibboleth.utilities.java.support.security.impl.RandomIdentifierGenerationStrategy;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.saml2.common.TimeBoundSAMLObject;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import se.litsec.opensaml.saml2.metadata.MetadataContainer;
import se.litsec.opensaml.utils.SignatureUtils;

public abstract class AbstractMetadataContainer<T extends TimeBoundSAMLObject & SignableSAMLObject>
implements MetadataContainer<T> {
    public static final Duration DEFAULT_VALIDITY = Duration.ofDays(7L);
    public static final float DEFAULT_UPDATE_FACTOR = 0.75f;
    public static final int DEFAULT_DESCRIPTOR_ID_SIZE = 32;
    private Logger logger = LoggerFactory.getLogger(AbstractMetadataContainer.class);
    protected T descriptor;
    protected Duration validity = DEFAULT_VALIDITY;
    protected float updateFactor = 0.75f;
    protected int idSize = 32;
    protected X509Credential signatureCredentials;

    public AbstractMetadataContainer(T descriptor, X509Credential signatureCredentials) {
        this.descriptor = descriptor;
        this.signatureCredentials = signatureCredentials;
    }

    @Override
    public T getDescriptor() {
        return this.descriptor;
    }

    @Override
    public T cloneDescriptor() throws MarshallingException, UnmarshallingException {
        return (T)((TimeBoundSAMLObject)XMLObjectSupport.cloneXMLObject(this.descriptor));
    }

    @Override
    public boolean updateRequired(boolean signatureRequired) {
        if (!this.descriptor.isValid() || signatureRequired && !((SignableXMLObject)this.descriptor).isSigned()) {
            return true;
        }
        if (this.descriptor.getValidUntil() == null) {
            return true;
        }
        long expireInstant = this.descriptor.getValidUntil().toEpochMilli();
        long now = System.currentTimeMillis();
        return this.updateFactor * (float)this.validity.toMillis() > (float)(expireInstant - now);
    }

    @Override
    public synchronized T update(boolean sign) throws SignatureException, MarshallingException {
        ((SignableXMLObject)this.descriptor).setSignature(null);
        RandomIdentifierGenerationStrategy generator = new RandomIdentifierGenerationStrategy(this.idSize);
        this.assignID(this.descriptor, generator.generateIdentifier(true));
        Instant now = Instant.now();
        Instant validUntil = now.plusSeconds((int)this.validity.getSeconds());
        this.descriptor.setValidUntil(validUntil);
        this.logger.debug("Descriptor '{}' was updated with ID '{}' and validUntil '{}'", new Object[]{this.getLogString(this.descriptor), this.getID(this.descriptor), this.descriptor.getValidUntil().toString()});
        return sign ? this.sign() : this.descriptor;
    }

    @Override
    public synchronized T sign() throws SignatureException, MarshallingException {
        this.logger.trace("Signing descriptor '{}' ...", (Object)this.getLogString(this.descriptor));
        if (this.getID(this.descriptor) == null || this.descriptor.getValidUntil() == null) {
            return this.update(true);
        }
        SignatureUtils.sign(this.descriptor, (Credential)this.signatureCredentials, new SignatureSigningConfiguration[]{SecurityConfigurationSupport.getGlobalSignatureSigningConfiguration()});
        this.logger.debug("Descriptor '{}' successfully signed.", (Object)this.getLogString(this.descriptor));
        return this.descriptor;
    }

    @Override
    public synchronized Element marshall() throws MarshallingException {
        return XMLObjectSupport.marshall(this.descriptor);
    }

    @Override
    public Duration getValidity() {
        return this.validity;
    }

    public void setValidity(Duration validity) {
        this.validity = validity;
    }

    @Override
    public float getUpdateFactor() {
        return this.updateFactor;
    }

    public void setUpdateFactor(float updateFactor) {
        if (updateFactor < 0.0f || updateFactor > 1.0f) {
            throw new IllegalArgumentException("Supplied updateFactor must be greater than 0 and equal or less than 1");
        }
        this.updateFactor = updateFactor;
    }

    public int getIdSize() {
        return this.idSize;
    }

    public void setIdSize(int idSize) {
        this.idSize = idSize;
    }

    protected abstract String getID(T var1);

    protected abstract void assignID(T var1, String var2);

    protected abstract String getLogString(T var1);
}

