/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.ext.saml2alg.DigestMethod;
import org.opensaml.saml.ext.saml2alg.SigningMethod;
import org.opensaml.saml.ext.saml2mdattr.EntityAttributes;
import org.opensaml.saml.ext.saml2mdui.Description;
import org.opensaml.saml.ext.saml2mdui.DisplayName;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import se.litsec.opensaml.utils.X509CertificateUtils;

public class MetadataUtils {
    public static <T> Optional<T> getMetadataExtension(Extensions extensions, Class<T> clazz) {
        if (extensions == null) {
            return Optional.empty();
        }
        return extensions.getUnknownXMLObjects().stream().filter(e -> clazz.isAssignableFrom(e.getClass())).map(clazz::cast).findFirst();
    }

    public static <T> List<T> getMetadataExtensions(Extensions extensions, Class<T> clazz) {
        if (extensions == null) {
            return Collections.emptyList();
        }
        return extensions.getUnknownXMLObjects().stream().filter(e -> clazz.isAssignableFrom(e.getClass())).map(clazz::cast).collect(Collectors.toList());
    }

    public static Optional<EntityAttributes> getEntityAttributes(EntityDescriptor ed) {
        return MetadataUtils.getMetadataExtension(ed.getExtensions(), EntityAttributes.class);
    }

    public static List<DisplayName> getUiDisplayNames(EntityDescriptor ed) {
        SSODescriptor ssoDescriptor = MetadataUtils.getSSODescriptor(ed);
        if (ssoDescriptor == null) {
            return Collections.emptyList();
        }
        Optional<UIInfo> uiInfo = MetadataUtils.getMetadataExtension(ssoDescriptor.getExtensions(), UIInfo.class);
        return uiInfo.map(UIInfo::getDisplayNames).orElseGet(Collections::emptyList);
    }

    public static Optional<String> getUiDisplayName(EntityDescriptor ed, String language) {
        return MetadataUtils.getUiDisplayNames(ed).stream().filter(dn -> language.equals(dn.getXMLLang())).map(XSString::getValue).findFirst();
    }

    public static List<Description> getUiDescriptions(EntityDescriptor ed) {
        SSODescriptor ssoDescriptor = MetadataUtils.getSSODescriptor(ed);
        if (ssoDescriptor == null) {
            return Collections.emptyList();
        }
        Optional<UIInfo> uiInfo = MetadataUtils.getMetadataExtension(ssoDescriptor.getExtensions(), UIInfo.class);
        return uiInfo.map(UIInfo::getDescriptions).orElseGet(Collections::emptyList);
    }

    public static Optional<String> getUiDescription(EntityDescriptor ed, String language) {
        return MetadataUtils.getUiDescriptions(ed).stream().filter(dn -> language.equals(dn.getXMLLang())).map(XSString::getValue).findFirst();
    }

    public static List<X509Credential> getMetadataCertificates(EntityDescriptor ed, UsageType usageType) {
        SSODescriptor descriptor = MetadataUtils.getSSODescriptor(ed);
        if (descriptor == null) {
            return Collections.emptyList();
        }
        ArrayList<X509Credential> creds = new ArrayList<X509Credential>();
        for (KeyDescriptor kd : descriptor.getKeyDescriptors()) {
            if (!usageType.equals((Object)kd.getUse()) && kd.getUse() != null && !UsageType.UNSPECIFIED.equals((Object)kd.getUse()) || kd.getKeyInfo() == null) continue;
            for (X509Data xd : kd.getKeyInfo().getX509Datas()) {
                for (X509Certificate cert : xd.getX509Certificates()) {
                    try {
                        creds.add((X509Credential)new BasicX509Credential(X509CertificateUtils.decodeCertificate(new ByteArrayInputStream(Base64.getDecoder().decode(cert.getValue())))));
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return creds;
    }

    public static List<DigestMethod> getDigestMethods(EntityDescriptor ed) {
        List<DigestMethod> methods;
        SSODescriptor descriptor = MetadataUtils.getSSODescriptor(ed);
        if (descriptor != null && !(methods = MetadataUtils.getMetadataExtensions(descriptor.getExtensions(), DigestMethod.class)).isEmpty()) {
            return methods;
        }
        return MetadataUtils.getMetadataExtensions(ed.getExtensions(), DigestMethod.class);
    }

    public static List<SigningMethod> getSigningMethods(EntityDescriptor ed) {
        List<SigningMethod> methods;
        SSODescriptor descriptor = MetadataUtils.getSSODescriptor(ed);
        if (descriptor != null && !(methods = MetadataUtils.getMetadataExtensions(descriptor.getExtensions(), SigningMethod.class)).isEmpty()) {
            return methods;
        }
        return MetadataUtils.getMetadataExtensions(ed.getExtensions(), SigningMethod.class);
    }

    public static SSODescriptor getSSODescriptor(EntityDescriptor ed) {
        if (ed.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol") != null) {
            return ed.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        }
        return ed.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
    }

    private MetadataUtils() {
    }
}

