/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata.build;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.metadata.Company;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.saml.saml2.metadata.EmailAddress;
import org.opensaml.saml.saml2.metadata.GivenName;
import org.opensaml.saml.saml2.metadata.SurName;
import org.opensaml.saml.saml2.metadata.TelephoneNumber;
import se.litsec.opensaml.core.AbstractSAMLObjectBuilder;

public class ContactPersonBuilder
extends AbstractSAMLObjectBuilder<ContactPerson> {
    public ContactPersonBuilder() {
    }

    public ContactPersonBuilder(ContactPerson template) throws MarshallingException, UnmarshallingException {
        super(template);
    }

    public static ContactPersonBuilder builder() {
        return new ContactPersonBuilder();
    }

    public static ContactPersonBuilder builder(ContactPerson template) throws MarshallingException, UnmarshallingException {
        return new ContactPersonBuilder(template);
    }

    public ContactPersonBuilder type(ContactPersonTypeEnumeration type) {
        ((ContactPerson)this.object()).setType(type);
        return this;
    }

    public ContactPersonBuilder company(String company) {
        if (company != null) {
            Company c = (Company)XMLObjectSupport.buildXMLObject((QName)Company.DEFAULT_ELEMENT_NAME);
            c.setValue(company);
            ((ContactPerson)this.object()).setCompany(c);
        }
        return this;
    }

    public ContactPersonBuilder givenName(String givenName) {
        if (givenName != null) {
            GivenName gn = (GivenName)XMLObjectSupport.buildXMLObject((QName)GivenName.DEFAULT_ELEMENT_NAME);
            gn.setValue(givenName);
            ((ContactPerson)this.object()).setGivenName(gn);
        }
        return this;
    }

    public ContactPersonBuilder surname(String surname) {
        if (surname != null) {
            SurName sn = (SurName)XMLObjectSupport.buildXMLObject((QName)SurName.DEFAULT_ELEMENT_NAME);
            sn.setValue(surname);
            ((ContactPerson)this.object()).setSurName(sn);
        }
        return this;
    }

    public ContactPersonBuilder emailAddresses(List<String> emailAddresses) {
        if (emailAddresses != null) {
            for (String e : emailAddresses) {
                EmailAddress ea = (EmailAddress)XMLObjectSupport.buildXMLObject((QName)EmailAddress.DEFAULT_ELEMENT_NAME);
                ea.setURI(e);
                ((ContactPerson)this.object()).getEmailAddresses().add(ea);
            }
        }
        return this;
    }

    public ContactPersonBuilder emailAddresses(String ... emailAddresses) {
        return this.emailAddresses(emailAddresses != null ? Arrays.asList(emailAddresses) : null);
    }

    public ContactPersonBuilder telephoneNumbers(List<String> telephoneNumbers) {
        if (telephoneNumbers != null) {
            for (String t : telephoneNumbers) {
                TelephoneNumber tn = (TelephoneNumber)XMLObjectSupport.buildXMLObject((QName)TelephoneNumber.DEFAULT_ELEMENT_NAME);
                tn.setValue(t);
                ((ContactPerson)this.object()).getTelephoneNumbers().add(tn);
            }
        }
        return this;
    }

    public ContactPersonBuilder telephoneNumbers(String ... telephoneNumbers) {
        return this.telephoneNumbers(telephoneNumbers != null ? Arrays.asList(telephoneNumbers) : null);
    }

    @Override
    protected Class<ContactPerson> getObjectType() {
        return ContactPerson.class;
    }
}

