/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata.build;

import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.metadata.EncryptionMethod;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.KeyName;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import se.litsec.opensaml.core.AbstractSAMLObjectBuilder;
import se.litsec.opensaml.utils.X509CertificateUtils;

public class KeyDescriptorBuilder
extends AbstractSAMLObjectBuilder<KeyDescriptor> {
    public static KeyDescriptorBuilder builder() {
        return new KeyDescriptorBuilder();
    }

    @Override
    protected Class<KeyDescriptor> getObjectType() {
        return KeyDescriptor.class;
    }

    public KeyDescriptorBuilder use(UsageType usageType) {
        if (UsageType.UNSPECIFIED.equals((Object)usageType)) {
            ((KeyDescriptor)this.object()).setUse(null);
        } else {
            ((KeyDescriptor)this.object()).setUse(usageType);
        }
        return this;
    }

    public KeyDescriptorBuilder keyName(String name) {
        if (name == null && ((KeyDescriptor)this.object()).getKeyInfo() != null && !((KeyDescriptor)this.object()).getKeyInfo().getKeyNames().isEmpty()) {
            ((KeyDescriptor)this.object()).getKeyInfo().getKeyNames().clear();
        }
        if (((KeyDescriptor)this.object()).getKeyInfo() == null) {
            ((KeyDescriptor)this.object()).setKeyInfo((KeyInfo)XMLObjectSupport.buildXMLObject((QName)KeyInfo.DEFAULT_ELEMENT_NAME));
        }
        ((KeyDescriptor)this.object()).getKeyInfo().getKeyNames().clear();
        KeyName keyName = (KeyName)XMLObjectSupport.buildXMLObject((QName)KeyName.DEFAULT_ELEMENT_NAME);
        keyName.setValue(name);
        ((KeyDescriptor)this.object()).getKeyInfo().getKeyNames().add(keyName);
        return this;
    }

    public KeyDescriptorBuilder certificate(java.security.cert.X509Certificate certificate) {
        try {
            return this.certificate(certificate != null ? Base64.getEncoder().encodeToString(certificate.getEncoded()) : null);
        }
        catch (CertificateEncodingException e) {
            throw new SecurityException(e);
        }
    }

    public KeyDescriptorBuilder certificate(InputStream certificate) {
        try {
            return this.certificate(certificate != null ? Base64.getEncoder().encodeToString(X509CertificateUtils.decodeCertificate(certificate).getEncoded()) : null);
        }
        catch (CertificateException e) {
            throw new SecurityException(e);
        }
    }

    public KeyDescriptorBuilder certificate(String base64Encoding) {
        if (base64Encoding == null && ((KeyDescriptor)this.object()).getKeyInfo() != null && !((KeyDescriptor)this.object()).getKeyInfo().getX509Datas().isEmpty()) {
            ((KeyDescriptor)this.object()).getKeyInfo().getX509Datas().clear();
        }
        if (((KeyDescriptor)this.object()).getKeyInfo() == null) {
            ((KeyDescriptor)this.object()).setKeyInfo((KeyInfo)XMLObjectSupport.buildXMLObject((QName)KeyInfo.DEFAULT_ELEMENT_NAME));
        }
        ((KeyDescriptor)this.object()).getKeyInfo().getX509Datas().clear();
        X509Data x509Data = (X509Data)XMLObjectSupport.buildXMLObject((QName)X509Data.DEFAULT_ELEMENT_NAME);
        X509Certificate cert = (X509Certificate)XMLObjectSupport.buildXMLObject((QName)X509Certificate.DEFAULT_ELEMENT_NAME);
        cert.setValue(base64Encoding);
        x509Data.getX509Certificates().add(cert);
        ((KeyDescriptor)this.object()).getKeyInfo().getX509Datas().add(x509Data);
        return this;
    }

    public KeyDescriptorBuilder certificate(X509Credential credential) {
        return this.certificate(credential != null ? credential.getEntityCertificate() : null);
    }

    public KeyDescriptorBuilder encryptionMethods(List<String> algorithms) {
        if (algorithms != null && !algorithms.isEmpty()) {
            for (String algo : algorithms) {
                EncryptionMethod method = (EncryptionMethod)XMLObjectSupport.buildXMLObject((QName)EncryptionMethod.DEFAULT_ELEMENT_NAME);
                method.setAlgorithm(algo);
                ((KeyDescriptor)this.object()).getEncryptionMethods().add(method);
            }
        } else {
            ((KeyDescriptor)this.object()).getEncryptionMethods().clear();
        }
        return this;
    }

    public KeyDescriptorBuilder encryptionMethods(String ... algorithms) {
        return this.encryptionMethods(algorithms != null ? Arrays.asList(algorithms) : null);
    }

    public KeyDescriptorBuilder encryptionMethodsExt(List<EncryptionMethod> algorithms) {
        if (algorithms != null && !algorithms.isEmpty()) {
            for (EncryptionMethod em : algorithms) {
                try {
                    ((KeyDescriptor)this.object()).getEncryptionMethods().add((EncryptionMethod)XMLObjectSupport.cloneXMLObject((XMLObject)em));
                }
                catch (MarshallingException | UnmarshallingException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            ((KeyDescriptor)this.object()).getEncryptionMethods().clear();
        }
        return this;
    }

    public KeyDescriptorBuilder encryptionMethods(EncryptionMethod ... algorithms) {
        return this.encryptionMethodsExt(algorithms != null ? Arrays.asList(algorithms) : null);
    }
}

